package ru.yandex.autotests.directapi.vcards.add;

import java.nio.charset.Charset;

import org.apache.commons.lang3.StringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.MapPointMap;
import ru.yandex.autotests.directapi.model.api5.vcards.PhoneMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.model.banners.PointOnMapMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by chicos on 02.09.14.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
public class AddVCardsNegativeTest {
    private static LogSteps log = LogSteps.getLogger(AddVCardsNegativeTest.class);

    private static final String SINGLE_CLIENT = VCardsLogins.SINGLE_CLIENT;

    private static final String AGENCY = VCardsLogins.AGENCY_VCARDS;
    private static final String SUBCLIENT1 = VCardsLogins.SUBCLIENT_VCARDS;
    private static final String SUBCLIENT2 = VCardsLogins.SUBCLIENT_VCARDS_2;

    private static final String ANOTHER_AGENCY = VCardsLogins.AGENCY_VCARDS_SHARD_2;

    private static Long campaignId;
    private static Long deletedCampaignId;
    private static Long archivedCampaignId;

    private static Long campaignId2;

    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareVCards() {
        api.userSteps.clientFakeSteps()
                .reshardUserWithLock(VCardsLogins.AGENCY_VCARDS_SHARD_2, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SINGLE_CLIENT);
        log.info("Создадим кампании");
        api.as(AGENCY);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(SUBCLIENT1);

        deletedCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(SUBCLIENT1);
        api.userSteps.campaignSteps().campaignsDelete(SUBCLIENT1, deletedCampaignId);

        api.as(SINGLE_CLIENT);
        archivedCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignSteps().campaignsSuspend(SINGLE_CLIENT, archivedCampaignId);
        api.userSteps.campaignSteps().campaignsArchive(SINGLE_CLIENT, archivedCampaignId);
        campaignId2 = api.userSteps.campaignSteps().addDefaultTextCampaign(SINGLE_CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3933")
    public void emptyVCardsPackTest() {
        api.as(SINGLE_CLIENT);
        api.userSteps.vCardsSteps().shouldGetVCardErrorOn(
                Action.ADD,
                new AddRequestMap(),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(AddRequestMap.VCARDS)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3932")
    public void noRequiredFieldCountryTest() {
        api.as(SINGLE_CLIENT);
        api.userSteps.vCardsSteps().shouldGetVCardErrorOn(
                Action.ADD,
                new AddRequestMap()
                        .withVCards(new VCardAddMap()
                                .shortContacts()
                                .withCountry(null)),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        path(AddRequestMap.VCARDS), path(VCardAddMap.COUNTRY)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3934")
    public void noRequiredFieldCityCodeTest() {
        api.as(SINGLE_CLIENT);
        api.userSteps.vCardsSteps().shouldGetVCardErrorOn(
                Action.ADD,
                new AddRequestMap()
                        .withVCards(new VCardAddMap()
                                .shortContacts()
                                .withPhone(new PhoneMap()
                                        .defaultPhone()
                                        .withCityCode(null))),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(PhoneMap.CITY_CODE)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3935")
    public void noRequiredFieldMapPointCoordinateTest() {
        api.as(SINGLE_CLIENT);
        api.userSteps.vCardsSteps().shouldGetVCardErrorOn(
                Action.ADD,
                new AddRequestMap()
                        .withVCards(new VCardAddMap()
                                .shortContacts()
                                .withPointOnMap(new MapPointMap()
                                        .withX(45.733604F).withY(45.72431F)
                                        .withX1(27.603739F).withY1(27.587273F).withX2(27.570807F))
                        ),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(PointOnMapMap.Y_2)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3936")
    public void addVCardWithZeroCampaignIdTest() {
        //https://st.yandex-team.ru/DIRECT-41085
        api.as(SINGLE_CLIENT);
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withVCards(new VCardAddMap().shortContacts()),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_IN_DETAILS, 0))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3937")
    public void addToNonExistingCampaignTest() {
        //https://st.yandex-team.ru/DIRECT-34791
        api.as(SINGLE_CLIENT);
        long nonExistingCampaing = 9478374L;
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap()
                        .withVCards(new VCardAddMap()
                                .shortContacts()
                                .withCampaignId(nonExistingCampaing)),
                ExpectedResult
                        .errors(new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_IN_DETAILS, nonExistingCampaing))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3938")
    public void addUsingInvalidCampaignIDTest() {
        api.as(SINGLE_CLIENT);
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap()
                        .withVCards(new VCardAddMap()
                                .shortContacts()
                                .withCampaignId(9239478374L)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_IN_DETAILS, 9239478374L))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3939")
    public void addToDeletedCampaignTest() {
        api.as(AGENCY);
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                SUBCLIENT1,
                new AddRequestMap()
                        .withVCards(new VCardAddMap()
                                .shortContacts()
                                .withCampaignId(deletedCampaignId)),
                ExpectedResult
                        .errors(new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_IN_DETAILS, deletedCampaignId))
        );
    }

    @Test
    @Description("Создаем агентством визитку субклиенту, указав кампанию другого субклиента")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3940")
    public void addToNotOwnedCampaignTest() {
        api.as(AGENCY);
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                SUBCLIENT2,
                new AddRequestMap()
                        .withVCards(new VCardAddMap()
                                .shortContacts()
                                .withCampaignId(campaignId)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_IN_DETAILS, campaignId))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3941")
    public void identicalVCardsToOneCampaignTest() {
        api.as(AGENCY);
        VCardAddMap vcard = new VCardAddMap().defaultContacts().withCampaignId(campaignId);
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                SUBCLIENT1,
                new AddRequestMap()
                        .withVCards(vcard, vcard),
                ExpectedResult.success(),
                ExpectedResult.warnings(new Notification(10100))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3942")
    public void invalidStringEncodingTest() {
        //https://st.yandex-team.ru/DIRECT-36594
        api.as(SINGLE_CLIENT);
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap()
                        .withVCards(new VCardAddMap()
                                .shortContacts()
                                .withCompanyName(new String("Питер-сити".getBytes(Charset.forName("UTF-8")),
                                        Charset.forName("CP1251")))
                                .withCountry(new String("Россия".getBytes(Charset.forName("UTF-8")),
                                        Charset.forName("CP1251")))
                                .withCity(new String("Санкт-Петербург".getBytes(Charset.forName("UTF-8")),
                                        Charset.forName("CP1251")))
                                .withCampaignId(campaignId2)),
                ExpectedResult.errors(
                        new Notification(5002, Api5ErrorDetailsJava.USE_SPECIFIED_ALPHABETS_IN_FIELD,
                                StringUtils.capitalize(VCardAddMap.COUNTRY)),
                        new Notification(5002, Api5ErrorDetailsJava.USE_SPECIFIED_ALPHABETS_IN_FIELD,
                                StringUtils.capitalize(VCardAddMap.CITY)),
                        new Notification(5002,
                                Api5ErrorDetailsJava.USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD_EN,
                                StringUtils.capitalize(VCardAddMap.COMPANY_NAME)))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3943")
    public void addToArchivedCampaignTest() {
        api.as(SINGLE_CLIENT);
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap()
                        .withVCards(new VCardAddMap()
                                .shortContacts()
                                .withCampaignId(archivedCampaignId)),
                ExpectedResult.errors(
                        new Notification(8300, Api5ErrorDetailsJava.COULD_NOT_ADD_VCARD_TO_ARCHIVED_CAMPAIGN,
                                archivedCampaignId))
        );
    }

    @Test
    @Description("Создаем агентством визитки субклиенту, в одной из которых указана чужая кампания")
    @ru.yandex.qatools.allure.annotations.TestCaseId("3944")
    public void addVCardNotOwnedCampaignByAgencyTest() {
        api.as(AGENCY);
        Long campaign1 = api.userSteps.campaignSteps().addDefaultTextCampaign(SUBCLIENT1);
        Long campaign2 = api.userSteps.campaignSteps().addDefaultTextCampaign(SUBCLIENT2);

        VCardAddMap item1 = new VCardAddMap().defaultContacts().withCampaignId(campaign1);
        VCardAddMap item2 = new VCardAddMap().defaultContacts().withCampaignId(campaign2);

        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                SUBCLIENT1,
                new AddRequestMap()
                        .withVCards(item1, item2),
                ExpectedResult.success(),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_IN_DETAILS, campaign2))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3945")
    public void addVCardByStrangeAgencyTest() {
        api.as(AGENCY);
        Long campaign = api.userSteps.campaignSteps().addDefaultTextCampaign(SUBCLIENT1);

        api.as(ANOTHER_AGENCY);
        api.userSteps.vCardsSteps().shouldGetVCardErrorOn(
                Action.ADD,
                SUBCLIENT1,
                new AddRequestMap()
                        .withVCards(new VCardAddMap()
                                .shortContacts()
                                .withCampaignId(campaign)),
                new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)
        );
    }
}
