package ru.yandex.autotests.directapi.vcards.add;

import java.util.List;
import java.util.Set;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.vcards.VCardGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.MapPointMap;
import ru.yandex.autotests.directapi.model.api5.vcards.PhoneMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.stream.Collectors.toSet;
import static org.hamcrest.Matchers.both;
import static org.hamcrest.Matchers.comparesEqualTo;
import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 30.05.14.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
public class AddVCardsPositiveTest {
    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;
    private static final String agency = VCardsLogins.AGENCY_VCARDS;
    private static final String subClient = VCardsLogins.SUBCLIENT_VCARDS;
    private static final String manager = Logins.MANAGER_DEFAULT;
    private static final String srvClient = VCardsLogins.SERVICED_CLIENT_VCARDS;
    private static final Long STATION_SPB = 20347l;
    @ClassRule
    public static ApiSteps api = new ApiSteps().wsdl(APIPort_PortType.class);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static LogSteps log = LogSteps.getLogger(AddVCardsPositiveTest.class);
    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(subClient);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(manager);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(srvClient);
        api.as(manager);
        api.userSteps.clientFakeSteps().enableAllowEditCampaigns(srvClient);
        //кампания необходимая для автоматического перевода на сервисируемость кампаний,
        //создаваемых сервисируемым клиентом с флагом withManagerAssistance
        api.userSteps.campaignSteps().campaignsUnarchive(srvClient, 9768624L);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3946")
    public void addOnlyRequiredFieldsTest() {
        api.as(singleClient);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
        VCardAddMap item = new VCardAddMap().shortContacts().withCampaignId(campaignID);
        List<Long> cardIds = api.userSteps.vCardsSteps().vCardsAdd(item);

        assertThat("размер списка IDs добавленных визиток", cardIds, hasSize(1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3947")
    public void addAllVCardFieldsTest() {
        api.as(singleClient);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        VCardAddMap item = new VCardAddMap().defaultContacts()
                .withCampaignId(campaignID)
                .withMetroStation(STATION_SPB)
                .withPointOnMap(new MapPointMap().defaultPointOnMap());
        List<Long> cardIds = api.as(singleClient).userSteps.vCardsSteps().vCardsAdd(item);

        assertThat("размер списка IDs добавленных визиток", cardIds, hasSize(1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3948")
    public void addVCardCampaignWithBannerTest() {
        api.as(singleClient);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(campaignID);
        List<Long> cardIds = api.as(singleClient).userSteps.vCardsSteps().vCardsAdd(item);

        assertThat("размер списка IDs добавленных визиток", cardIds, hasSize(1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3949")
    public void addVCardByAgencyTest() {
        api.as(agency);
        Long idSubclient = api.userSteps.campaignSteps().addDefaultTextCampaign(subClient);
        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(idSubclient);
        List<Long> cardIds = api.userSteps.vCardsSteps().vCardsAdd(subClient, item);

        assertThat("размер списка IDs добавленных визиток", cardIds, hasSize(1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3950")
    public void addVCardByManagerTest() {
        api.as(manager);
        Long servCampaign = api.userSteps.campaignSteps().addDefaultTextCampaign(srvClient);
        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(servCampaign);
        List<Long> cardIds = api.userSteps.vCardsSteps().vCardsAdd(srvClient, item);

        assertThat("размер списка IDs добавленных визиток", cardIds, hasSize(1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3951")
    public void addVCardByServicedClientTest() {
        api.as(manager);
        log.info("Создаем менеджером кампанию для пользователя " + srvClient);
        Long servCampaign = api.userSteps.campaignSteps().addDefaultTextCampaign(srvClient);

        log.info("Создаем визитку сервисируемым клиентом" + srvClient);
        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(servCampaign);
        api.as(srvClient);
        List<Long> cardIds = api.userSteps.vCardsSteps().vCardsAdd(item);

        assertThat("размер списка IDs добавленных визиток", cardIds, hasSize(1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3952")
    public void addVCardByManagerForCampaignCreatedByClientTest() {
        api.as(srvClient);
        log.info("Создаем кампанию для передачи на сервисируемость менеджеру");
        Long campaingId = api.userSteps.campaignSteps().addDefaultTextCampaignWithRequireServicing(YesNoEnum.YES, srvClient);

        api.as(manager);
        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(campaingId);
        List<Long> cardIds = api.userSteps.vCardsSteps().vCardsAdd(srvClient, item);

        assertThat("размер списка IDs добавленных визиток", cardIds, hasSize(1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3953")
    public void addVCardCountry8City800Test() {
        api.as(singleClient);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        VCardAddMap item = new VCardAddMap()
                .shortContacts()
                .withCampaignId(campaignID)
                .withPhone(new PhoneMap()
                        .defaultPhone()
                        .withCountryCode("8")
                        .withCityCode("800"));
        List<Long> cardIds = api.userSteps.vCardsSteps().vCardsAdd(item);

        assertThat("размер списка IDs добавленных визиток", cardIds, hasSize(1));
    }

    @Test
    public void testAddressIdDontDependFromAppartment() {
        api.as(singleClient);
        Long campaignId = api.userSteps.campaignSteps()
                .addDefaultTextCampaign(singleClient);
        List<Long> vcardIds = api.userSteps.vCardsSteps().vCardsAdd(
                new VCardAddMap().defaultContacts()
                        .withCampaignId(campaignId),
                new VCardAddMap().defaultContacts()
                        .withCampaignId(campaignId)
                        .withApartment("98"),
                new VCardAddMap().defaultContacts()
                        .withCampaignId(campaignId)
                        .withApartment("98а"),
                new VCardAddMap().defaultContacts()
                        .withCampaignId(campaignId)
                        .withApartment("98б"),
                new VCardAddMap().defaultContacts()
                        .withCampaignId(campaignId)
                        .withApartment("1"));

        Set<Long> addressIds = vcardIds.stream()
                .map(vcardId -> api.userSteps.getDirectJooqDbSteps()
                        .useShardForLogin(singleClient)
                        .vCardSteps()
                        .getVCards(vcardId)
                        .getAddressId())
                // Мы ожидаем реальный id-к
                .map(addressId -> addressId != null ? addressId : 0)
                .collect(toSet());

        assertThat(
                "Все адреса должны иметь один ненулевой addressId",
                addressIds,
                both(hasSize(1)).and(contains(not(0))));
    }

    @Test
    public void addUpdatedVcard() throws InterruptedException {
        api.as(singleClient);
        DirectJooqDbSteps directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(singleClient);
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(singleClient);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);

        VCardAddMap vcardAddMap = new VCardAddMap().defaultContacts()
                .withExtraMessage("Extra")
                .withCampaignId(campaignId);

        List<Long> ids = api.userSteps.vCardsSteps().vCardsAdd(vcardAddMap);

        assumeThat("Карточка должна быть добавлена", ids, hasSize(1));

        Long vcardId = ids.get(0);
        Long bannerId = api.userSteps.adsSteps().addDefaultDynamicTextAdWithVCardId(adGroupId, vcardId);

        directJooqDbSteps.bannersSteps().updateBanners(
                new BannersRecord().setBid(bannerId).setStatusbssynced(BannersStatusbssynced.Yes));

        BannersRecord adBeforeUpdate = directJooqDbSteps.bannersSteps().getBanner(bannerId);

        assumeThat("statusBsSynced должен быть YES", adBeforeUpdate.getStatusbssynced(),
                is(BannersStatusbssynced.Yes));

        VCardGetItem oldVcard = api.userSteps.vCardsSteps().vCardsGet(vcardId).get(0);

        VCardAddMap anotherVcardAddMap = new VCardAddMap().defaultContacts()
                .withCampaignId(campaignId)
                .withExtraMessage("Extra")
                .withPointOnMap(new MapPointMap().defaultPointOnMap().withX("100.00"));

        // От добавления визитки до обновления должна пройти хотя бы секунда
        // Иначе, тест будет падать, если и добавление, и обновление произошли в течение секунды, т.к.
        // lastChange имеет точность в одну секунду st/DIRECT-127216
        Thread.sleep(1000);

        api.userSteps.vCardsSteps().shouldGetResultOn(Action.ADD, new AddRequestMap().withVCards(anotherVcardAddMap),
                ExpectedResult.warnings(new Notification(10100)));

        BannersRecord ad = directJooqDbSteps.bannersSteps().getBanner(bannerId);
        VCardGetItem newVcard = api.userSteps.vCardsSteps().vCardsGet(vcardId).get(0);

        assertThat("Значения карточки должны измениться",
                newVcard.getPointOnMap().getValue().getX(), not(comparesEqualTo(oldVcard.getPointOnMap().getValue().getX())));
        assertThat("statusBsSynced должен измениться на NO", ad.getStatusbssynced(), is(BannersStatusbssynced.No));
        assertThat("lastChange должен обновиться", adBeforeUpdate.getLastchange(), not(is(ad.getLastchange())));
    }

    @Test
    public void addDuplicatedVcard() {
        api.as(singleClient);
        DirectJooqDbSteps directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(singleClient);
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(singleClient);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);

        VCardAddMap vcardAddMap = new VCardAddMap().defaultContacts()
                .withExtraMessage("Extra")
                .withCampaignId(campaignId);

        List<Long> ids = api.userSteps.vCardsSteps().vCardsAdd(vcardAddMap);

        assumeThat("Карточка должна быть успешно добавлена", ids, hasSize(1));

        Long vcardId = ids.get(0);
        Long bannerId = api.userSteps.adsSteps().addDefaultDynamicTextAdWithVCardId(adGroupId, vcardId);
        directJooqDbSteps.bannersSteps().updateBanners(
                new BannersRecord().setBid(bannerId).setStatusbssynced(BannersStatusbssynced.Yes));

        BannersRecord adBeforeUpdate = directJooqDbSteps.bannersSteps().getBanner(bannerId);

        VCardAddMap anotherVcardAddMap = new VCardAddMap().defaultContacts()
                .withCampaignId(campaignId)
                .withExtraMessage("Extra");

        api.userSteps.vCardsSteps().shouldGetResultOn(Action.ADD, new AddRequestMap().withVCards(anotherVcardAddMap),
                ExpectedResult.warnings(new Notification(10100)));

        BannersRecord ad = directJooqDbSteps.bannersSteps().getBanner(bannerId);

        assertThat("statusBsSynced должен остаться прежним", ad.getStatusbssynced(),
                is(adBeforeUpdate.getStatusbssynced()));
        assertThat("lastChange должен остаться прежним", adBeforeUpdate.getLastchange(), is(ad.getLastchange()));
    }
}
