package ru.yandex.autotests.directapi.vcards.add;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 14.10.14.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddVCardsRolesAccessAgencyTest {
    private static LogSteps log = LogSteps.getLogger(AddVCardsRolesAccessAgencyTest.class);

    private static final String agency = VCardsLogins.AGENCY_VCARDS_2;
    private static final String subclient = VCardsLogins.SUBCLIENT_VCARDS_4;
    private static long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameters(name = "operator = {0}")
    public static Collection logins() {
        Object[][] data = new Object[][]{
                {VCardsLogins.AGENCY_VCARDS_2_REP},
                {VCardsLogins.AGENCY_VCARDS_2_REP_CLIENTS},
                {Logins.SUPPORT}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareCampaign() {
        log.info("Создадим кампанию агентством");
        api.as(agency);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(subclient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3954")
    public void addVCardByRoleTest() {
        log.info("Добавим визитку ролью");
        api.as(operator);
        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(campaignId);
        List<Long> cardIds = api.userSteps.vCardsSteps().vCardsAdd(subclient, item);

        assertThat("размер списка IDs добавленных визиток", cardIds, hasSize(1));
    }
}
