package ru.yandex.autotests.directapi.vcards.add.phone;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.VcardsRecord;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.vcards.PhoneMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by onotole on 27.06.16.
 * https://st.yandex-team.ru/TESTIRT-9556
 */

@Aqua.Test
@Features(VCardsFeatures.ADD)
@Issue("https://st.yandex-team.ru/DIRECT-55106")
@Description("Код города не обязателен для визиток Турции с номерами начинающимися на 444")
public class AddVCardsPhoneCheckDB {
    private static final String SINGLE_CLIENT = VCardsLogins.SINGLE_CLIENT;
    private Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SINGLE_CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Test
    public void addVCardWithSpecialFormatPhoneNumber() {
        String phoneNumber = "444-12-34";
        String countryCode = "+90";
        String cityCode = "";
        String expectedPhone = "+90##444-12-34#";
        VCardAddMap item = new VCardAddMap()
                .shortContacts()
                .withCampaignId(campaignID)
                .withPhone(new PhoneMap()
                        .withPhoneNumber(phoneNumber)
                        .withCountryCode(countryCode)
                        .withCityCode(cityCode));

        api.userSteps.vCardsSteps().vCardsAdd(SINGLE_CLIENT, item);
        VcardsRecord contacts = api.userSteps.getDirectJooqDbSteps().useShardForLogin(SINGLE_CLIENT).vCardSteps().getVCardsByCid(campaignID);

        assumeThat("визитка записалась в базу", contacts, notNullValue());
        assertThat ("номер телефона записался в нужном формате", contacts.getPhone(), equalTo(expectedPhone));

    }
}
