package ru.yandex.autotests.directapi.vcards.add.phone;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.PhoneMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by onotole on 24.06.16.
 * https://st.yandex-team.ru/TESTIRT-9556
 */

@Aqua.Test
@Features(VCardsFeatures.ADD)
@Issue("https://st.yandex-team.ru/DIRECT-55106")
@Description("проверка специальных номеров телефонов с +8")
@RunWith(Parameterized.class)
public class AddVCardsPhoneCountryCodeTest {

    private static final String SINGLE_CLIENT = VCardsLogins.SINGLE_CLIENT;
    private Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SINGLE_CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String countryCode;

    @Parameterized.Parameter(value = 1)
    public String cityCode;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedError;

    @Parameterized.Parameters(name = "countryCode = {0}, cityCode = {1}")
    public static Collection contactInfoSet() {

        Object[][] data = new Object[][]{
                {"+0", "800",
                        ExpectedResult.errors(
                                new Notification(5004,
                                        Api5ErrorDetailsJava.CONTACT_INFO_COUNTRY_CODE_WITH_CITY_CODE_SHOULD_NOT_START_WITH_PLUS,
                                        0, 800))},
                {"7", "800",
                        ExpectedResult.errors(
                                new Notification(5004,
                                        Api5ErrorDetailsJava.CONTACT_INFO_COUNTRY_CODE_MUST_START_FROM))},
                {"+8", "800",
                        ExpectedResult.errors(
                                new Notification(5004,
                                        Api5ErrorDetailsJava.CONTACT_INFO_COUNTRY_CODE_WITH_CITY_CODE_SHOULD_NOT_START_WITH_PLUS,
                                        8, 800))},
                {"+8", "804",
                        ExpectedResult.errors(
                                new Notification(5004,
                                        Api5ErrorDetailsJava.CONTACT_INFO_COUNTRY_CODE_WITH_CITY_CODE_SHOULD_NOT_START_WITH_PLUS,
                                        8, 804))},

                //https://st.yandex-team.ru/DIRECT-63950
                {"12345", "804",
                        ExpectedResult.errors(
                                new Notification(5004,
                                        Api5ErrorDetailsJava.INVALID_COUNTRY_CODE_FORMAT))},
                {"1234", "804",
                        ExpectedResult.errors(
                                new Notification(5004,
                                        Api5ErrorDetailsJava.CONTACT_INFO_COUNTRY_CODE_MUST_START_FROM))},
                {"+1234", "804",
                        ExpectedResult.success()},
                {"8", "800",
                        ExpectedResult.success()},
                {"+7", "800",
                        ExpectedResult.success()},
                {"+8", "495",
                        ExpectedResult.success()},
                {"+7", "495",
                        ExpectedResult.success()},
                {"8", "804",
                        ExpectedResult.success()},
                {"0", "800",
                        ExpectedResult.success()},
        };
        return Arrays.asList(data);
    }

    @Test
    public void createVCardWithPhoneNumberWithPlusProblemsTest() {

        VCardAddMap item = new VCardAddMap()
                .shortContacts()
                .withCampaignId(campaignID)
                .withPhone(new PhoneMap()
                        .defaultPhone()
                        .withCountryCode(countryCode)
                        .withCityCode(cityCode)
                );

        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap()
                        .withVCards(item),
                expectedError
        );
    }
}
