package ru.yandex.autotests.directapi.vcards.add.phone;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.vcards.VCardGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.vcards.PhoneMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 10.10.14.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddVCardsPhoneNumberSegmentsTest {
    private static LogSteps log = LogSteps.getLogger(AddVCardsPhoneNumberSegmentsTest.class);

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;

    private static Long campaignId;
    private static long vCardId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String countryCode;

    @Parameterized.Parameter(value = 1)
    public String phoneNumber;

    @Parameterized.Parameter(value = 2)
    public String expectedPhoneNumber;

    @Parameterized.Parameters(name = "country = {0}, phone = {1}, expected = {2} ")
    public static Collection fieldsValue() {
        Object[][] data = new Object[][]{
                {"+7", "12345", "1-23-45"},
                {"+7", "123456", "12-34-56"},
                {"+7", "1234567", "123-45-67"},
                {"+7", "123456789", "123-45-67-89"},
                {"+7", "23-45-6-7-8", "234-56-78"},
                //https://st.yandex-team.ru/DIRECT-15317
                {"+7", "012345", "01-23-45"},
                //https://st.yandex-team.ru/DIRECT-17941
                {"+380", "12 34-567", "123-45-67"},
                {"+375", "12345-6-7-8", "12-34-56-78"},
                {"+1", "123 45-6-7-89", "123 45-6-7-89"}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
    }

    @Before
    public void prepareVCard() {
        log.info("Создадим визитку");
        VCardAddMap item = new VCardAddMap()
                .shortContacts()
                .withCampaignId(campaignId)
                .withPhone(new PhoneMap()
                                .defaultPhone()
                                .withCountryCode(countryCode)
                                .withPhoneNumber(phoneNumber)
                );
        List<Long> cardIds = api.userSteps.vCardsSteps().vCardsAdd(item);
        assumeThat("визитка создана", cardIds.size(), equalTo(1));
        vCardId = cardIds.get(0);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3963")
    public void phoneTest() {
        List<VCardGetItem> vCards = api.as(singleClient).userSteps.vCardsSteps().vCardsGet(vCardId);

        assertThat("номер телефона корректно сегментирован", vCards.get(0).getPhone().getPhoneNumber(), equalTo(expectedPhoneNumber));
    }
}
