package ru.yandex.autotests.directapi.vcards.add.phone;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.StringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.PhoneMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 04.09.14.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddVCardsPhoneSeparatedTest {

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;

    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String fieldName;

    @Parameterized.Parameter(value = 1)
    public String description;

    @Parameterized.Parameter(value = 2)
    public String value;

    @Parameterized.Parameter(value = 3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "field = {0}, test = {1}")
    public static Collection fieldsValue() {
        Object[][] data = new Object[][]{
                {PhoneMap.CITY_CODE, "Пустая строка",
                        "", ExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.EMPTY_AREA_CODE))},
                {PhoneMap.CITY_CODE, "Минимальная длина 1",
                        "1", ExpectedResult.success()},
                {PhoneMap.CITY_CODE, "Максимальная длина 5",
                        "12345", ExpectedResult.success()},
                {PhoneMap.CITY_CODE, "Длина 6 превышает допустимую",
                        "123456",
                        ExpectedResult.errors(new Notification(5004, Api5ErrorDetailsJava.INVALID_AREA_CODE_FORMAT))},
                {PhoneMap.CITY_CODE, "Недопустимые символы",
                        "ABCD",
                        ExpectedResult.errors(new Notification(5004, Api5ErrorDetailsJava.INVALID_AREA_CODE_FORMAT))},

                {PhoneMap.PHONE_NUMBER, "Пустая строка",
                        "", ExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.EMPTY_PHONE_NUMBER))},
                {PhoneMap.PHONE_NUMBER, "Длина 4 меньше допустимой",
                        "1234", ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetailsJava.INVALID_PHONE_NUMBER_FORMAT))},
                {PhoneMap.PHONE_NUMBER, "Минимальная длина 5",
                        "12345", ExpectedResult.success()},
                {PhoneMap.PHONE_NUMBER, "Максимальная длина 9",
                        "123456789", ExpectedResult.success()},
                {PhoneMap.PHONE_NUMBER, "Длина 10 превышает допустимую",
                        "1234567890", ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetailsJava.INVALID_PHONE_NUMBER_FORMAT))},
                {PhoneMap.PHONE_NUMBER, "Недопустимые символы",
                        "ABCDEFG", ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetailsJava.INVALID_PHONE_NUMBER_FORMAT))},

                {PhoneMap.COUNTRY_CODE, "Пустая строка",
                        "", ExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.EMPTY_COUNTRY_CODE))},
                {PhoneMap.COUNTRY_CODE, "Некорректный формат (без плюса)",
                        "12", ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetailsJava.COUNTRY_CODE_MUST_START_WITH_PLUS))},
                {PhoneMap.COUNTRY_CODE, "Минимальная длина 1",
                        "+1", ExpectedResult.success()},
                {PhoneMap.COUNTRY_CODE, "Максимальная длина 4",
                        "+1234", ExpectedResult.success()},
                {PhoneMap.COUNTRY_CODE, "Длина 5 превышает допустимую",
                        "+12345", ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetailsJava.INVALID_COUNTRY_CODE_FORMAT))},
                {PhoneMap.COUNTRY_CODE, "Код +8",
                        "+8", ExpectedResult.success()},
                {PhoneMap.COUNTRY_CODE, "Недопустимые символы",
                        "ABC", ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetailsJava.INVALID_COUNTRY_CODE_FORMAT))},

                {PhoneMap.EXTENSION, "Минимальная длина 1",
                        "1", ExpectedResult.success()},
                {PhoneMap.EXTENSION, "Максимальная длина 6",
                        "123456", ExpectedResult.success()},
                {PhoneMap.EXTENSION, "Длина 7 превышает допустимую",
                        "1234567", ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetailsJava.INVALID_PHONE_EXTENSION_FORMAT))},
                {PhoneMap.EXTENSION, "Недопустимые символы",
                        "ABC", ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetailsJava.INVALID_PHONE_EXTENSION_FORMAT))},
                {PhoneMap.EXTENSION, "Пустая строка в extention", "", ExpectedResult.success()},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareVCards() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3964")
    public void phoneFieldsLengthTest() {
        //https://st.yandex-team.ru/DIRECT-34834
        VCardAddMap vcard = new VCardAddMap().shortContacts().withCampaignId(campaignId);
        PhoneMap phone = new PhoneMap()
                .defaultPhone();
        ReflectionUtils.setBeanMapFieldValue(phone, "with" + StringUtils.capitalize(fieldName), value);
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withVCards(vcard.withPhone(phone)),
                expectedResult
        );
    }
}
