package ru.yandex.autotests.directapi.vcards.add.phone;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.PhoneMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by onotole on 23.06.16.
 * https://st.yandex-team.ru/TESTIRT-9556
 */

@Aqua.Test
@Features(VCardsFeatures.ADD)
@Issue("https://st.yandex-team.ru/DIRECT-55106")
@Description("Код города не обязателен для визиток Турции с номерами начинающимися на 444")
@RunWith(Parameterized.class)
public class AddVCardsPhoneSpecialFormatTest {
    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long campaignId;

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String countryCode;

    @Parameterized.Parameter(value = 1)
    public String cityCode;

    @Parameterized.Parameter(value = 2)
    public String phoneNumber;

    @Parameterized.Parameter(value = 3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "county = {0} city = {1} phone = {2}")
    public static Collection vCardInfoSet() {
        Object[][] data = new Object[][]{
                {"+90", "", "444-12-34", ExpectedResult.success()},
                {"+90", "123", "444-12-34", ExpectedResult.success()},
                {"+90", "", "443-12-34", ExpectedResult.errors(
                        new Notification(5005, Api5ErrorDetailsJava.EMPTY_AREA_CODE))},
                {"+80", "", "444-12-34", ExpectedResult.errors(
                        new Notification(5005, Api5ErrorDetailsJava.EMPTY_AREA_CODE))},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void addCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
    }

    @Test
    public void addVCardWithSpecialFormatPhoneNumber() {
        VCardAddMap item = new VCardAddMap()
                .shortContacts()
                .withCampaignId(campaignId)
                .withPhone(new PhoneMap()
                        .withPhoneNumber(phoneNumber)
                        .withCountryCode(countryCode)
                        .withCityCode(cityCode));

        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap()
                        .withVCards(item),
                expectedResult
        );
    }
}
