package ru.yandex.autotests.directapi.vcards.add.phone;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.PhoneMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 10.10.14.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddVCardsPhoneTotalTest {

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;

    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String country;

    @Parameterized.Parameter(value = 2)
    public String city;

    @Parameterized.Parameter(value = 3)
    public String phone;

    @Parameterized.Parameter(value = 4)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection fieldsValue() {
        Object[][] data = new Object[][]{
                {"Общая длина 7",
                        "+7", "1", "12345",
                        ExpectedResult.errors(
                                new Notification(5004, Api5ErrorDetailsJava.INVALID_PHONE_NUMBER_FORMAT))},
                {"Общая длина 8",
                        "+7", "12", "12345",
                        ExpectedResult.success()},
                {"Общая длина 17",
                        "+3801", "45691", "12345678",
                        ExpectedResult.success()},
                {"Общая длина 18",
                        "+3801", "45691", "123456789",
                        ExpectedResult.errors(
                                new Notification(5004, Api5ErrorDetailsJava.INVALID_PHONE_NUMBER_FORMAT))},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3965")
    public void phoneTest() {
        VCardAddMap vcard = new VCardAddMap().shortContacts().withCampaignId(campaignId);
        PhoneMap phoneMap = new PhoneMap()
                .withCountryCode(country)
                .withCityCode(city)
                .withPhoneNumber(phone);
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap()
                        .withVCards(vcard.withPhone(phoneMap)),
                expectedResult
        );
    }
}
