package ru.yandex.autotests.directapi.vcards.add.point;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.MapPointMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 15.09.14.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddVCardsFieldsMapPointTest {

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;

    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public MapPointMap point;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection mapPoints() {
        Object[][] data = new Object[][]{
                {"Корректные координаты и корректное окно", new MapPointMap()
                        .pointOnMapCentered(),
                        ExpectedResult.success()},
                {"Нулевые координаты и корректное окно", new MapPointMap()
                        .withX(0f)
                        .withY(0f)
                        .withX1(-0.000010f)
                        .withY1(-0.000010f)
                        .withX2(0.000010f)
                        .withY2(0.000010f),
                        ExpectedResult.success()},
                {"Все три координаты совпадают", new MapPointMap()
                        .withX(60.101010f)
                        .withY(30.101010f)
                        .withX1(60.101010f)
                        .withY1(30.101010f)
                        .withX2(60.101010f)
                        .withY2(30.101010f),
                        ExpectedResult.success()},
                {"Точка вне окна", new MapPointMap()
                        .withX(60.301010f)
                        .withY(30.301010f)
                        .withX1(60.101010f)
                        .withY1(30.101010f)
                        .withX2(60.001010f)
                        .withY2(30.201010f),
                        ExpectedResult.success()},
                {"Нулевые координаты и пустое окно", new MapPointMap()
                        .withX(0f)
                        .withY(0f)
                        .withX1(0f)
                        .withY1(0f)
                        .withX2(0f)
                        .withY2(0f),
                        ExpectedResult.success()},
                {"Некоторые координаты точек некорректны", new MapPointMap()
                        .withX(60.301010f)
                        .withY(93.301010f)
                        .withX1(60.100010f)
                        .withY1(30.102010f)
                        .withX2(-180.102010f)
                        .withY2(30.100010f),
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.Y"),
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.X2"))},
                {"Все координаты точек некорректны", new MapPointMap()
                        .withX(180.000010f)
                        .withY(92.101010f)
                        .withX1(-260.101010f)
                        .withY1(-93.101010f)
                        .withX2(280.101010f)
                        .withY2(91.101010f),
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.X"),
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.Y"),
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.X1"),
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.Y1"),
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.X2"),
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.Y2")
                        )},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3966")
    public void mapPointTest() {
        //https://st.yandex-team.ru/DIRECT-36252
        //MapPointMap point = new MapPointMap().defaultPointOnMap().setPointScale(6);
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withVCards(new VCardAddMap()
                        .shortContacts()
                        .withCompanyName("Some Company " + RandomStringUtils.randomAlphabetic(10))
                        .withCampaignId(campaignId)
                        .withPointOnMap(point)
                ),
                expectedResult
        );
    }
}
