package ru.yandex.autotests.directapi.vcards.add.point;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.MapPointMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap.POINT_ON_MAP;

/**
 * Created by chicos on 15.09.14.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddVCardsMapPointRangeTest {

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;

    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String fieldName;

    @Parameterized.Parameter(value = 2)
    public String value;

    @Parameterized.Parameter(value = 3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection mapPoints() {
        Object[][] data = new Object[][]{
                // X
                {"X < -180", MapPointMap.X, "181",
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.X"))},
                {"X = -180", MapPointMap.X, "180",
                        ExpectedResult.success()},
                {"X = -10", MapPointMap.X, "10",
                        ExpectedResult.success()},
                {"X = 0", MapPointMap.X, "0",
                        ExpectedResult.success()},
                {"X = 30", MapPointMap.X, "30",
                        ExpectedResult.success()},
                {"X = 180", MapPointMap.X, "180",
                        ExpectedResult.success()},
                {"X = 180.0001", MapPointMap.X, "180.0001",
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.X"))},
                {"X > 180", MapPointMap.X, "181",
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.X"))},

                // Y
                {"Y < -90", MapPointMap.Y, "-91",
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.Y"))},
                {"Y = -90.0001", MapPointMap.Y, "-90.0001",
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.Y"))},
                {"Y = -90", MapPointMap.Y, "-90",
                        ExpectedResult.success()},
                {"Y = -12", MapPointMap.Y, "-12",
                        ExpectedResult.success()},
                {"Y = 0", MapPointMap.Y, "0",
                        ExpectedResult.success()},
                {"Y = 45", MapPointMap.Y, "45",
                        ExpectedResult.success()},
                {"Y = 90", MapPointMap.Y, "90",
                        ExpectedResult.success()},
                {"Y > 90", MapPointMap.Y, "92",
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.Y"))},

                // X1
                {"X1 < -180", MapPointMap.X_1, "181",
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.X1"))},
                {"X1 = -180", MapPointMap.X_1, "180",
                        ExpectedResult.success()},
                {"X1 = -10", MapPointMap.X_1, "-10",
                        ExpectedResult.success()},
                {"X1 = 0", MapPointMap.X_1, "0",
                        ExpectedResult.success()},
                {"X1 = 30", MapPointMap.X_1, "30",
                        ExpectedResult.success()},
                {"X1 = 180", MapPointMap.X_1, "180",
                        ExpectedResult.success()},
                {"X1 = 180.0001", MapPointMap.X_1, "180.0001",
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.X1"))},
                {"X1 > 180", MapPointMap.X_1, "181",
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.X1"))},
                // Y1
                {"Y1 < -90", MapPointMap.Y_1, "-91",
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.Y1"))},
                {"Y1 = -90.0001", MapPointMap.Y_1, "-90.0001",
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.Y1"))},
                {"Y1 = -90", MapPointMap.Y_1, "-90",
                        ExpectedResult.success()},
                {"Y1 = -12", MapPointMap.Y_1, "-12",
                        ExpectedResult.success()},
                {"Y1 = 0", MapPointMap.Y_1, "0",
                        ExpectedResult.success()},
                {"Y1 = 45", MapPointMap.Y_1, "45",
                        ExpectedResult.success()},
                {"Y1 = 90", MapPointMap.Y_1, "90",
                        ExpectedResult.success()},
                {"Y1 > 90", MapPointMap.Y_1, "92",
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.Y1"))},

                // X2
                {"X2 < -180", MapPointMap.X_2, "-181",
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.X2"))},
                {"X2 = -180", MapPointMap.X_2, "-180",
                        ExpectedResult.success()},
                {"X2 = -10", MapPointMap.X_2, "-10",
                        ExpectedResult.success()},
                {"X2 = 0", MapPointMap.X_2, "0",
                        ExpectedResult.success()},
                {"X2 = 30", MapPointMap.X_2, "30",
                        ExpectedResult.success()},
                {"X2 = 180", MapPointMap.X_2, "180",
                        ExpectedResult.success()},
                {"X2 = 180.0001", MapPointMap.X_2, "180.0001",
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.X2"))},
                {"X2 > 180", MapPointMap.X_2, "181",
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.X2"))},
                // Y2
                {"Y2 < -90", MapPointMap.Y_2, "-91",
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.Y2"))},
                {"Y2 = -90.0001", MapPointMap.Y_2, "-90.0001",
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.Y2"))},
                {"Y2 = -90", MapPointMap.Y_2, "-90",
                        ExpectedResult.success()},
                {"Y2 = -12", MapPointMap.Y_2, "-12",
                        ExpectedResult.success()},
                {"Y2 = 0", MapPointMap.Y_2, "0",
                        ExpectedResult.success()},
                {"Y2 = 45", MapPointMap.Y_2, "45",
                        ExpectedResult.success()},
                {"Y2 = 90", MapPointMap.Y_2, "90",
                        ExpectedResult.success()},
                {"Y2 > 90", MapPointMap.Y_2, "92",
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD, "PointOnMap.Y2"))}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3967")
    public void mapPointTest() {
        //https://st.yandex-team.ru/DIRECT-36252
        MapPointMap point = new MapPointMap().pointOnMapCentered();
        point.put(fieldName, value);
        final VCardAddMap vcardAddMap = new VCardAddMap()
                .shortContacts()
                .withCompanyName("Some Company " + RandomStringUtils.randomAlphabetic(10))
                .withCampaignId(campaignId);
        vcardAddMap.put(POINT_ON_MAP, point.getBean());

        api.userSteps.vCardsSteps().shouldGetResultOn(Action.ADD,
                new AddRequestMap().withVCards(vcardAddMap), expectedResult);
    }
}
