package ru.yandex.autotests.directapi.vcards.add.point;

import com.yandex.direct.api.v5.vcards.AddResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.InstantMessengerMap;
import ru.yandex.autotests.directapi.model.api5.vcards.MapPointMap;
import ru.yandex.autotests.directapi.model.api5.vcards.PhoneMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.utils.matchers.BeanEqualsAssert.assertThat;

/**
 * Created by ginger on 11.02.16.
 * https://st.yandex-team.ru/TESTIRT-8356
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-39956")
@Features(VCardsFeatures.BUG)
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.BUG)
@Description("Проверка статуса BsSync после изменения PointOnMap")
public class AddVcardStatusBsSyncAndVcardIdTest {
    private static LogSteps log = LogSteps.getLogger(AddVCardsMapPointRangeTest.class);
    public static String country = "Россия";
    public static String city = "Санкт-Петербург";
    public static String companyName = "Питер-сити";
    public static String workTime = "0;3;10;0;18;0;4;6;10;0;11;0";
    public static Float newX = 13f;
    private static Long vcardId;
    private static Long updatedVcardId;
    private static Long adGroupId;
    private static Long adId;

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;

    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);


    @BeforeClass
    public static void prepareCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        log.info("Добавим визитку");
        vcardId = api.userSteps.vCardsSteps().vCardsAdd(
                new VCardAddMap()
                        .withCountry(country)
                        .withCity(city)
                        .withCompanyName(companyName)
                        .withWorkTime(workTime)
                        .withPhone(new PhoneMap().defaultPhone())
                        .withInstantMessenger(new InstantMessengerMap().defaultInstantMessenger())
                        .withCampaignId(campaignId)
                        .withPointOnMap(new MapPointMap().defaultPointOnMap())
                ).get(0);

        log.info("Создадим объявление с визиткой");

        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withTextAd(new TextAdAddMap().defaultTextAd().withVCardId(vcardId))
                .withAdGroupId(adGroupId));


        log.info("выставим статус синхронизации с БК");
        api.userSteps.bannersFakeSteps().setStatusBsSynced(adId, Value.YES);
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(adGroupId, Value.YES);

        log.info("Обновим MapPoint визитки");
        updatedVcardId = ((AddResponse) api.userSteps.vCardsSteps().shouldGetResultOn(
                ServiceNames.VCARDS,
                singleClient,
                Action.ADD,
                new AddRequestMap()
                        .withVCards(
                                new VCardAddMap()
                                    .withCountry(country)
                                    .withCity(city)
                                    .withCompanyName(companyName)
                                    .withWorkTime(workTime)
                                    .withPhone(new PhoneMap().defaultPhone())
                                    .withInstantMessenger(new InstantMessengerMap().defaultInstantMessenger())
                                    .withCampaignId(campaignId)
                                    .withPointOnMap(new MapPointMap().defaultPointOnMap().withX(newX))),
                                ExpectedResult.warnings(new Notification(10100))
        )).getAddResults().get(0).getId();
    }

    @Test
    @Description("При обновлении MapPoint объявление переотправляется в БК")
    @Issue("DIRECT-51130")
    public void bannerStatusBsSyncedTest() {
        BannerFakeInfo bannerInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assertThat("баннеру установился нужный статус синхронизации с БК",
                bannerInfo.getStatusBsSynced(), equalTo(Value.NO));
    }

    @Test
    @Description("При обновлении MapPoint группа не переотправляется в БК")
    public void groupStatusBsSyncedTest() {
        GroupFakeInfo groupInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assertThat("у группы остался неизменным статус синхронизации с БК",
                groupInfo.getStatusBsSynced(), equalTo(Value.YES));
    }

    @Test
    @Description("При обновлении MapPoint VcardId не меняется")
    public void compareVcardIdAfterUpdatingMapPoints() {
        assertThat("у визитки остался неизменным ID",
                vcardId, equalTo(updatedVcardId));
    }

}
