package ru.yandex.autotests.directapi.vcards.add.point;


import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.vcards.VCardGetItem;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.json.simple.parser.ParseException;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.vcards.MapPointMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.utils.matchers.BeanEqualsAssert.assertThat;

/**
 * Created by ginger on 11.02.16.
 * https://st.yandex-team.ru/TESTIRT-8356
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-39956")
@Features(VCardsFeatures.ADD)
@Description("Проверка сохранения целочисленных значений PointOnMap")
@RunWith(Parameterized.class)
public class AddVcardsIntegerMapPointTest {
    private static final String singleClient = VCardsLogins.SINGLE_CLIENT_4;
    public static Integer integerPointValue = 90;
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(singleClient);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trasher = new Trashman(api);
    @Parameterized.Parameter(value = 0)
    public String description;
    @Parameterized.Parameter(value = 1)
    public String fieldName;
    protected LogSteps log = LogSteps.getLogger(this.getClass());
    private Long campaignId;
    private Long vcardId;

    @Parameterized.Parameters(name = "{0}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {"X = 90", MapPointMap.X},
                {"X_1 = 90", MapPointMap.X_1},
                {"X_2 = 90", MapPointMap.X_2},
                {"Y = 90", MapPointMap.Y},
                {"Y_1 = 90", MapPointMap.Y_1},
                {"Y_2 = 90", MapPointMap.Y_2}

        });
    }

    @Before
    public void beforeClass() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    public void pointOnMapWithIntegerPointTest()
            throws ParseException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {

        MapPointMap pointMap = new MapPointMap().pointOnMapCentered();
        pointMap.put(fieldName, integerPointValue.toString());

        final VCardAddMap vcardAddMap = new VCardAddMap()
                .shortContacts()
                .withCompanyName("Some Company " + RandomStringUtils.randomAlphabetic(10))
                .withCampaignId(campaignId);
        vcardAddMap.put(VCardAddMap.POINT_ON_MAP, pointMap.getBean());

        vcardId = api.userSteps.vCardsSteps().vCardsAdd(vcardAddMap).get(0);

        VCardGetItem vcard = api.userSteps.vCardsSteps().vCardsGet(vcardId).get(0);
        BigDecimal
                valueOfUpdatedField = (BigDecimal) PropertyUtils.getProperty(vcard.getPointOnMap().getValue(), fieldName);

        assertThat("верно сохранилась точка на карте",
                valueOfUpdatedField.compareTo(BigDecimal.valueOf(integerPointValue)), equalTo(0));

    }
}
