package ru.yandex.autotests.directapi.vcards.add.validation;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.InstantMessengerMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.model.banners.IMClient;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 05.09.14.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddVCardsFieldsIMTest {

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;

    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String imClient;

    @Parameterized.Parameter(value = 1)
    public String imLogin;

    @Parameterized.Parameter(value = 2)
    public String description;

    @Parameterized.Parameter(value = 3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "client = {0}, test = {2}, login = {1}")
    public static Collection fieldsValue() {
        Object[][] data = new Object[][]{
                {IMClient.ICQ, "",
                        "Пустой логин",
                        ExpectedResult.errors(new Notification(5004, Api5ErrorDetailsJava.INVALID_IM_LOGIN_ICQ))},
                {IMClient.ICQ, RandomStringUtils.randomNumeric(4),
                        "Длина логина 4 меньше допустимого",
                        ExpectedResult.errors(new Notification(5004, Api5ErrorDetailsJava.INVALID_IM_LOGIN_ICQ))},
                {IMClient.ICQ, RandomStringUtils.randomNumeric(5),
                        "Минимальная длина логина 5", ExpectedResult.success()},
                {IMClient.ICQ, RandomStringUtils.randomNumeric(10),
                        "Максимальная длина логина 10", ExpectedResult.success()},
                {IMClient.ICQ, RandomStringUtils.randomNumeric(11),
                        "Длина логина 11 больше допустимого",
                        ExpectedResult.errors(new Notification(5004, Api5ErrorDetailsJava.INVALID_IM_LOGIN_ICQ))},
                {IMClient.ICQ, RandomStringUtils.randomNumeric(4) + "-" + RandomStringUtils.randomNumeric(4) + "-"
                        + RandomStringUtils.randomNumeric(1),
                        "Логин с дефисами", ExpectedResult.success()},
                {IMClient.ICQ, RandomStringUtils.randomAlphabetic(8),
                        "Логин с буквами",
                        ExpectedResult.errors(new Notification(5004, Api5ErrorDetailsJava.INVALID_IM_LOGIN_ICQ))},
                {IMClient.ICQ, "1-2-3-4-5-6-7-8-9-0-0", //https://st.yandex-team.ru/DIRECT-63950#1489403803000
                        "Логин c 11 цифрами",
                        ExpectedResult.errors(new Notification(5004, Api5ErrorDetailsJava.INVALID_IM_LOGIN_ICQ))},
                {IMClient.SKYPE, "",
                        "Пустой логин",
                        ExpectedResult.errors(new Notification(5004, Api5ErrorDetailsJava.INVALID_IM_LOGIN_SKYPE))},
                {IMClient.SKYPE, "valid_skype-login",
                        "Корректный логин", ExpectedResult.success()},
                {IMClient.SKYPE, "invalid!login123",
                        "Логин с недопустимыми символами",
                        ExpectedResult.errors(new Notification(5004, Api5ErrorDetailsJava.INVALID_IM_LOGIN_SKYPE))},
                {IMClient.MAIL_AGGENT, "",
                        "Пустой логин", ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetailsJava.INVALID_IM_LOGIN_MAIL_AGENT))},
                {IMClient.MAIL_AGGENT, "wonderfull.mail@mail.ru",
                        "Логин домена mail.ru", ExpectedResult.success()},
                {IMClient.MAIL_AGGENT, "wonderfull.mail@list.ru",
                        "Логин домена list.ru", ExpectedResult.success()},
                {IMClient.MAIL_AGGENT, "wonderfull.mail@bk.ru",
                        "Логин домена bk.ru", ExpectedResult.success()},
                {IMClient.MAIL_AGGENT, "wonderfull.mail@inbox.ru",
                        "Логин домена inbox.ru", ExpectedResult.success()},
                {IMClient.MAIL_AGGENT, "wonderfull.mail@rambler.ru",
                        "Неподдерживаемый домен rambler.ru",
                        ExpectedResult.errors(
                                new Notification(5004, Api5ErrorDetailsJava.INVALID_IM_LOGIN_MAIL_AGENT))},
                {IMClient.MAIL_AGGENT, "wonderfull.email@mail.com",
                        "Неподдерживаемая зона .com",
                        ExpectedResult.errors(new Notification(5004, Api5ErrorDetailsJava.INVALID_IM_LOGIN_MAIL_AGENT))}

        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareVCards() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3969")
    public void imLoginTest() {
        //https://st.yandex-team.ru/DIRECT-35406
        InstantMessengerMap im = new InstantMessengerMap()
                .withIMClient(imClient)
                .withIMLogin(imLogin);
        VCardAddMap card = new VCardAddMap().defaultContacts()
                .withCampaignId(campaignId)
                .withInstantMessenger(im);

        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withVCards(card),
                expectedResult
        );
    }
}
