package ru.yandex.autotests.directapi.vcards.add.validation;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by chicos on 02.09.14.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddVCardsFieldsLengthTest {

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;

    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String fieldName;

    @Parameterized.Parameter(value = 1)
    public String description;

    @Parameterized.Parameter(value = 2)
    public String value;

    @Parameterized.Parameter(value = 3)
    public ExpectedResult expectedResult;


    @Parameterized.Parameters(name = "field = {0}, test = {1}")
    public static Collection fieldsValue() {
        Object[][] data = new Object[][]{
                {VCardAddMap.COUNTRY, "Максимальная длина 50",
                        RandomStringUtils.randomAlphabetic(50),
                        ExpectedResult.success()},
                {VCardAddMap.COUNTRY, "Длина 51 превышает допустимую",
                        RandomStringUtils.randomAlphabetic(51),
                        ExpectedResult.errors(
                                new Notification(5001, Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                                        path(VCardAddMap.COUNTRY), 50))},

                {VCardAddMap.CITY, "Максимальная длина 55",
                        RandomStringUtils.randomAlphabetic(55),
                        ExpectedResult.success()},
                {VCardAddMap.CITY, "Длина 56 превышает допустимую",
                        RandomStringUtils.randomAlphabetic(56),
                        ExpectedResult.errors(
                                new Notification(5001, Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                                        path(VCardAddMap.CITY), 55))},

                {VCardAddMap.STREET, "Пустая строка",
                        "",
                        ExpectedResult.errors(new Notification(5000, Api5ErrorDetailsJava.NO_VALUE_IN_FIELD,
                                StringUtils.capitalize(VCardAddMap.STREET)))},
                {VCardAddMap.STREET, "Максимальная длина 55",
                        RandomStringUtils.randomAlphabetic(55),
                        ExpectedResult.success()},
                {VCardAddMap.STREET, "Длина 56 превышает допустимую",
                        RandomStringUtils.randomAlphabetic(56),
                        ExpectedResult.errors(
                                new Notification(5001, Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                                        path(VCardAddMap.STREET), 55))},

                {VCardAddMap.COUNTRY, "Пустая строка",
                        "",
                        ExpectedResult.errors(new Notification(5000, Api5ErrorDetailsJava.NO_VALUE_IN_FIELD,
                                StringUtils.capitalize(VCardAddMap.COUNTRY)))},
                {VCardAddMap.COUNTRY, "Максимальная длина 50",
                        RandomStringUtils.randomAlphabetic(50),
                        ExpectedResult.success()},
                {VCardAddMap.COUNTRY, "Длина 51 превышает допустимую",
                        RandomStringUtils.randomAlphabetic(51),
                        ExpectedResult.errors(
                                new Notification(5001, Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                                        path(VCardAddMap.COUNTRY), 50))},

                {VCardAddMap.CITY, "Пустая строка",
                        "",
                        ExpectedResult.errors(new Notification(5000, Api5ErrorDetailsJava.NO_VALUE_IN_FIELD,
                                StringUtils.capitalize(VCardAddMap.CITY)))},
                {VCardAddMap.CITY, "Максимальная длина 55",
                        RandomStringUtils.randomAlphabetic(55),
                        ExpectedResult.success()},
                {VCardAddMap.CITY, "Длина 56 превышает допустимую",
                        RandomStringUtils.randomAlphabetic(56),
                        ExpectedResult.errors(
                                new Notification(5001, Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                                        path(VCardAddMap.CITY), 55))},

                {VCardAddMap.COMPANY_NAME, "Пустая строка",
                        "",
                        ExpectedResult.errors(new Notification(5000, Api5ErrorDetailsJava.NO_VALUE_IN_FIELD,
                                StringUtils.capitalize(VCardAddMap.COMPANY_NAME)))},
                {VCardAddMap.COMPANY_NAME, "Максимальная длина 255",
                        RandomStringUtils.randomAlphabetic(255),
                        ExpectedResult.success()},
                {VCardAddMap.COMPANY_NAME, "Длина 256 превышает допустимую",
                        RandomStringUtils.randomAlphabetic(256),
                        ExpectedResult.errors(
                                new Notification(5001, Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                                        path(VCardAddMap.COMPANY_NAME), 255))},

                {VCardAddMap.EXTRA_MESSAGE, "Пустая строка",
                        "",
                        ExpectedResult.errors(new Notification(5000, Api5ErrorDetailsJava.NO_VALUE_IN_FIELD,
                                StringUtils.capitalize(VCardAddMap.EXTRA_MESSAGE)))},
                {VCardAddMap.EXTRA_MESSAGE, "Максимальная длина 200",
                        RandomStringUtils.randomAlphabetic(200),
                        ExpectedResult.success()},
                {VCardAddMap.EXTRA_MESSAGE, "Длина 201 превышает допустимую",
                        RandomStringUtils.randomAlphabetic(201),
                        ExpectedResult.errors(
                                new Notification(5001, Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                                        path(VCardAddMap.EXTRA_MESSAGE), 200))},

                {VCardAddMap.CONTACT_PERSON, "Пустая строка",
                        "",
                        ExpectedResult.errors(new Notification(5000, Api5ErrorDetailsJava.NO_VALUE_IN_FIELD,
                                StringUtils.capitalize(VCardAddMap.CONTACT_PERSON)))},
                {VCardAddMap.CONTACT_PERSON, "Максимальная длина 155",
                        RandomStringUtils.randomAlphabetic(155),
                        ExpectedResult.success()},
                {VCardAddMap.CONTACT_PERSON, "Длина 156 превышает допустимую",
                        RandomStringUtils.randomAlphabetic(156),
                        ExpectedResult.errors(
                                new Notification(5001, Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                                        path(VCardAddMap.CONTACT_PERSON), 155))}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareVCards() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3970")
    public void fieldsLengthTest() {
        //https://st.yandex-team.ru/DIRECT-34812
        //https://st.yandex-team.ru/DIRECT-36026
        VCardAddMap vcard = new VCardAddMap().shortContacts().withCampaignId(campaignId);
        ReflectionUtils.setBeanMapFieldValue(vcard, "with" + StringUtils.capitalize(fieldName), value);
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withVCards(vcard),
                expectedResult
        );
    }
}
