package ru.yandex.autotests.directapi.vcards.add.validation;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.RegionNameValues;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 05.09.14.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddVCardsFieldsMetroTest {

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;

    private static final Long STATION_MOSCOW = 20375L;
    private static final Long STATION_SPB = 20347L;
    private static final Long STATION_KIEV = 101892L;

    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String city;

    @Parameterized.Parameter(value = 1)
    public Long metroId;

    @Parameterized.Parameter(value = 2)
    public String metroIdComment;

    @Parameterized.Parameter(value = 3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "city = {0}, metro station = {2}")
    public static Collection fieldsValue() {
        Object[][] data = new Object[][]{
                {RegionNameValues.SAINT_PETERSBURG.getRussianName(), STATION_SPB,
                        "Станция из СПб", ExpectedResult.success()},
                {RegionNameValues.MOSCOW.getRussianName(), STATION_MOSCOW,
                        "Станция из Москвы", ExpectedResult.success()},
                {RegionNameValues.KIEV.getRussianName(), STATION_KIEV,
                        "Станция из Киева", ExpectedResult.success()},
                {RegionNameValues.SAINT_PETERSBURG.getEnglishName(), STATION_SPB,
                        "Станция из СПб", ExpectedResult.success()},
                {RegionNameValues.SAINT_PETERSBURG.getRussianName(), STATION_MOSCOW,
                        "Станция из Москвы",
                        ExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.INVALID_METRO_STATION))},
                {RegionNameValues.KIEV.getRussianName(), STATION_SPB,
                        "Станция из СПб",
                        ExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.INVALID_METRO_STATION))},
                {RegionNameValues.SAINT_PETERSBURG.getRussianName(), 12345L,
                        "Несуществующиая станция",
                        ExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.INVALID_METRO_STATION))},
                {"санкт петербург", STATION_SPB,
                        "Станция из СПб",
                        ExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.INVALID_METRO_STATION))},
                {"Урюпинск", STATION_KIEV,
                        "Станция из Киева",
                        ExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.INVALID_METRO_STATION))},
                {"Урюпинск", 12345L,
                        "Несуществующиая станция",
                        ExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.INVALID_METRO_STATION))},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareVCards() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3971")
    public void metroStationTest() {
        //https://st.yandex-team.ru/DIRECT-35406
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withVCards(new VCardAddMap()
                        .defaultContacts()
                        .withCampaignId(campaignId)
                        .withCity(city)
                        .withMetroStation(metroId)
                ),
                expectedResult
        );
    }
}
