package ru.yandex.autotests.directapi.vcards.add.validation;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by chicos on 05.09.14.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddVCardsFieldsOGRNTest {

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;

    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String ogrnValue;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}, ogrn = {1}")
    public static Collection fieldsValue() {
        Object[][] data = new Object[][]{
                {"Корректный длина 13", "1037739010891",
                        ExpectedResult.success()},
                {"Корректный длина 15", "304463210700212",
                        ExpectedResult.success()},
                {"Пустая строка", "",
                        ExpectedResult.errors(new Notification(5000, Api5ErrorDetailsJava.NO_VALUE_IN_FIELD,
                                path(VCardAddMap.OGRN)))},
                {"Строка из пробелов длина 13", "             ",
                        ExpectedResult.errors(new Notification(5000, Api5ErrorDetailsJava.NO_VALUE_IN_FIELD,
                                path(VCardAddMap.OGRN)))},
                {"Длина 12 меньше допустимой", "205469702317",
                        ExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD,
                                path(VCardAddMap.OGRN)))},
                {"Длина 14 некорректная", "10425645800658",
                        ExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD,
                                path(VCardAddMap.OGRN)))},
                {"Длина 16 некорректная", "3044632107002125",
                        ExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD,
                                path(VCardAddMap.OGRN)))}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3972")
    public void ogrnTest() {
        //https://st.yandex-team.ru/DIRECT-35406
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withVCards(new VCardAddMap()
                        .defaultContacts()
                        .withCampaignId(campaignId)
                        .withOgrn(ogrnValue)
                ),
                expectedResult
        );
    }
}
