package ru.yandex.autotests.directapi.vcards.add.validation;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.StringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 10.10.14.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddVCardsFieldsWorkTimeTest {

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;

    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String workTime;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection mapPoints() {
        Object[][] data = new Object[][]{
                {"Пустая строка",
                        "",
                        ExpectedResult.errors(new Notification(5000, Api5ErrorDetailsJava.NO_VALUE_IN_FIELD,
                                StringUtils.capitalize(VCardAddMap.WORK_TIME)))},
                {"Корректное время работы",
                        "0;3;10;0;18;0;4;6;10;0;11;0",
                        ExpectedResult.success()},
                {"Корректное время работы с двойными нулями",
                        "0;3;10;00;18;00;4;6;10;00;11;00",
                        ExpectedResult.success()},
                {"Время закрытия раньше времени открытия",
                        "0;6;19;0;17;0",
                        ExpectedResult.success()},
                {"День конца раньше дня начала",
                        "4;1;10;0;17;0",
                        ExpectedResult.success()},
                {"Некорректный номер дня недели",
                        "0;7;10;0;17;0",
                        ExpectedResult.errors(new Notification(5004, Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED,
                                StringUtils.capitalize(VCardAddMap.WORK_TIME)))},
                {"Некорректный час окончания",
                        "0;6;10;0;25;0",
                        ExpectedResult.errors(new Notification(5004, Api5ErrorDetailsJava.WORK_TIME_INTERVAL_FORMAT))},
                {"Некорректный час начала",
                        "0;6;24;0;20;0",
                        ExpectedResult.errors(new Notification(5004, Api5ErrorDetailsJava.WORK_TIME_INTERVAL_FORMAT))},
                {"Отрицательный час начала",
                        "0;6;-12;0;20;0",
                        ExpectedResult.errors(new Notification(5004, Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED,
                                StringUtils.capitalize(VCardAddMap.WORK_TIME)))},
                {"Время работы для одного дня",
                        "0;0;10;0;20;0",
                        ExpectedResult.success()},
                {"Некорректные минуты начала",
                        "0;6;12;61;20;0",
                        ExpectedResult.errors(new Notification(5004, Api5ErrorDetailsJava.WORK_TIME_INTERVAL_FORMAT))},
                {"Некорректные минуты окончания",
                        "0;6;12;10;20;-1",
                        ExpectedResult.errors(new Notification(5004, Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED,
                                StringUtils.capitalize(VCardAddMap.WORK_TIME)))},
                {"Некорректный разделитель",
                        "0,6,12,10,20,0",
                        ExpectedResult.errors(new Notification(5004, Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED,
                                StringUtils.capitalize(VCardAddMap.WORK_TIME)))},
                {"Некорректные символы",
                        "0;6;12;0;20;A",
                        ExpectedResult.errors(new Notification(5004, Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED,
                                StringUtils.capitalize(VCardAddMap.WORK_TIME)))},
                {"Редкие значения минут работы",
                        "0;6;10;11;20;37",
                        ExpectedResult.errors(
                                new Notification(5004,
                                        Api5ErrorDetailsJava.WORK_TIME_MINUTES_SHOULD_BE_DIVISIBLE_BY_15))},
                {"С пробелами между сегментами",
                        "0;6; 12;0; 20;00",
                        ExpectedResult.errors(new Notification(5004, Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED,
                                StringUtils.capitalize(VCardAddMap.WORK_TIME)))},
                {"Для каждого дня свое время",
                        "0;0;10;0;11;0;" +
                                "1;1;12;0;13;0;" +
                                "2;2;14;0;15;0;" +
                                "3;3;16;0;17;0;" +
                                "4;4;18;0;19;0;" +
                                "5;5;20;0;21;0;" +
                                "6;6;22;0;23;0;",
                        ExpectedResult.success()}

        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3973")
    public void workTimeTest() {
        //https://st.yandex-team.ru/DIRECT-36027
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withVCards(new VCardAddMap()
                        .defaultContacts()
                        .withCampaignId(campaignId)
                        .withWorkTime(workTime)
                ),
                expectedResult
        );
    }
}
