package ru.yandex.autotests.directapi.vcards.add.validation;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 20.10.14.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
public class AddVCardsIndependentValidationTest {
    private static LogSteps log = LogSteps.getLogger(AddVCardsIndependentValidationTest.class);

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3974")
    public void optionalFieldInvalidInFollowedVCardsTest() {
        log.info("Проверим, что валидация поля работает независимо от переданных в соседних визитках значениях");
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);

        VCardAddMap firstItem = new VCardAddMap().shortContacts()
                .withCampaignId(campaignID);
        VCardAddMap secondItem = new VCardAddMap().shortContacts()
                .withContactPerson(RandomStringUtils.randomAlphabetic(156))
                .withCampaignId(campaignID);
        VCardAddMap thirdItem = new VCardAddMap().shortContacts()
                .withContactPerson(RandomStringUtils.randomAlphabetic(156))
                .withCampaignId(campaignID);

        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap()
                        .withVCards(firstItem, secondItem, thirdItem),
                ExpectedResult.success(),
                ExpectedResult.errors(new Notification(5001, Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                        StringUtils.capitalize(VCardAddMap.CONTACT_PERSON), 155)),
                ExpectedResult.errors(new Notification(5001, Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                        StringUtils.capitalize(VCardAddMap.CONTACT_PERSON), 155))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3975")
    public void optionalFieldInvalidInLastVCardTest() {
        //https://st.yandex-team.ru/DIRECT-36026
        log.info("Проверим, что валидация поля работает независимо от переданных в соседних визитках значениях");
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);

        VCardAddMap firstItem = new VCardAddMap().shortContacts()
                .withCampaignId(campaignID)
                .withContactPerson("Контактный Персон");
        VCardAddMap secondItem = new VCardAddMap().shortContacts()
                .withCampaignId(campaignID);
        VCardAddMap thirdItem = new VCardAddMap().shortContacts()
                .withContactPerson("")
                .withCampaignId(campaignID);

        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap()
                        .withVCards(firstItem, secondItem, thirdItem),
                ExpectedResult.success(),
                ExpectedResult.success(),
                ExpectedResult.errors(new Notification(5000, Api5ErrorDetailsJava.NO_VALUE_IN_FIELD,
                        StringUtils.capitalize(VCardAddMap.CONTACT_PERSON)))
        );
    }
}
