package ru.yandex.autotests.directapi.vcards.add.validation;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.vcards.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 05.11.14.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@Description("Валидация полей при множественных некорректных данных")
public class AddVCardsMultipleValidationTest {

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3976")
    public void requiredAndOptionalFiledsInvalidTest() {
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);

        VCardAddMap vcardItem = new VCardAddMap().shortContacts()
                .withCampaignId(campaignID)
                .withCountry(RandomStringUtils.randomAlphabetic(51))
                .withOgrn(RandomStringUtils.randomNumeric(14));

        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap()
                        .withVCards(vcardItem),
                ExpectedResult.errors(
                        new Notification(5005, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD,
                                StringUtils.capitalize(VCardAddMap.OGRN)),
                        new Notification(5001, Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                                StringUtils.capitalize(VCardAddMap.COUNTRY), 50)
                )
        );
    }
}
