package ru.yandex.autotests.directapi.vcards.add.validation;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.vcards.VCardGetItem;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 16.10.14.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddVCardsOptionalFieldsWithSpacesTest {

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;

    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String fieldName;

    @Parameterized.Parameter(value = 1)
    public String description;

    @Parameterized.Parameter(value = 2)
    public String value;

    @Parameterized.Parameter(value = 3)
    public ExpectedResult expectedResult;


    @Parameterized.Parameters(name = "field = {0}, test = {1}")
    public static Collection fieldsValue() {
        Object[][] data = new Object[][]{
                {VCardAddMap.OGRN, "Пробел в начале, длина 14",
                        " 1037739010891",
                        ExpectedResult.success()},
                {VCardAddMap.STREET, "Максимальная длина 55 + пробелы",
                        " " + RandomStringUtils.randomAlphabetic(55) + " ",
                        ExpectedResult.success()},
                {VCardAddMap.COMPANY_NAME, "Максимальная длина 255 + пробелы",
                        " " + RandomStringUtils.randomAlphabetic(255) + " ",
                        ExpectedResult.success()},
                {VCardAddMap.EXTRA_MESSAGE, "Максимальная длина 200 + пробелы",
                        " " + RandomStringUtils.randomAlphabetic(200) + " ",
                        ExpectedResult.success()},
                {VCardAddMap.CONTACT_PERSON, "Максимальная длина 155 + пробелы",
                        " " + RandomStringUtils.randomAlphabetic(155) + " ",
                        ExpectedResult.success()},
                {VCardAddMap.CONTACT_EMAIL, "Пробелы в начале и в конце",
                        " " + RandomStringUtils.randomAlphabetic(10) + "@yandex-team.ru  ",
                        ExpectedResult.success()}

        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareCampaign(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3977")
    public void fieldsWithSpacesTest() {
        //https://st.yandex-team.ru/DIRECT-36027
        VCardAddMap vCard = new VCardAddMap().shortContacts().withCampaignId(campaignId);
        ReflectionUtils.setBeanMapFieldValue(vCard, "with" + StringUtils.capitalize(fieldName), value);
        List<Long> cardIds = api.as(singleClient).userSteps.vCardsSteps().vCardsAdd(vCard);
        assumeThat("создана визитка", cardIds, hasSize(1));
        List<VCardGetItem> vCards = api.as(singleClient).userSteps.vCardsSteps().vCardsGet(cardIds.get(0));

        Object fieldValue = ReflectionUtils.invokeGetter(vCards.get(0), StringUtils.capitalize(fieldName));

        assertThat("поле " + fieldName + " сохранено без лишних пробелов",
                (String)ReflectionUtils.invokeGetter(fieldValue, "Value"),
                equalTo(value.trim())
        );
    }
}
