package ru.yandex.autotests.directapi.vcards.add.validation;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.vcards.VCardGetItem;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
/**
 * Created by chicos on 16.10.14.
 */
@Aqua.Test
@Features(VCardsFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddVCardsRequiredFieldsWithSpacesTest {

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;

    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String fieldName;

    @Parameterized.Parameter(value = 1)
    public String description;

    @Parameterized.Parameter(value = 2)
    public String value;

    @Parameterized.Parameter(value = 3)
    public ExpectedResult expectedResult;


    @Parameterized.Parameters(name = "field = {0}, test = {1}")
    public static Collection fieldsValue() {
        Object[][] data = new Object[][]{
                {VCardAddMap.COUNTRY, "Пробел в начале и в конце",
                        " Суперстрана ",
                        ExpectedResult.success()},
                {VCardAddMap.COUNTRY, "Максимальная длина 50 + пробелы",
                        " " + RandomStringUtils.randomAlphabetic(50) + " ",
                        ExpectedResult.success()},
                {VCardAddMap.CITY, "Пробел в начале и в конце",
                        " Супергород ",
                        ExpectedResult.success()},
                {VCardAddMap.CITY, "Максимальная длина 55 + пробелы",
                        " " + RandomStringUtils.randomAlphabetic(55) + " ",
                        ExpectedResult.success()},
                {VCardAddMap.WORK_TIME, "Пробелы в начале и в конце",
                        " 0;6;10;0;20;0 ",
                        ExpectedResult.success()}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareCampaign(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3978")
    public void fieldsWithSpacesTest() {
        //https://st.yandex-team.ru/DIRECT-36027
        VCardAddMap vCard = new VCardAddMap().shortContacts().withCampaignId(campaignId);
        ReflectionUtils.setBeanMapFieldValue(vCard, "with" + StringUtils.capitalize(fieldName), value);
        List<Long> cardIds = api.as(singleClient).userSteps.vCardsSteps().vCardsAdd(vCard);
        assumeThat("создана визитка", cardIds, hasSize(1));

        List<VCardGetItem> vCards = api.as(singleClient).userSteps.vCardsSteps().vCardsGet(cardIds.get(0));
        assertThat("поле " + fieldName + " сохранено без лишних пробелов",
                (String)ReflectionUtils.invokeGetter(vCards.get(0), StringUtils.capitalize(fieldName)),
                equalTo(value.trim())
        );
    }
}
