package ru.yandex.autotests.directapi.vcards.delete;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.junit.AfterClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.errors.Path;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.vcards.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;

/**
 * Created by chicos on 12.12.14.
 */
@Aqua.Test
@Features(VCardsFeatures.DELETE)
@Tag(TagDictionary.TRUNK)
@Stories(ApiStories.JSON5)
@RunWith(Parameterized.class)
public class DeleteVCardsNegativeJsonTest {
    private static LogSteps log = LogSteps.getLogger(DeleteVCardsNegativeJsonTest.class);

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;
    private static Long campaignId;

    private static long cardId1;
    private static long cardId2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient).protocol(ProtocolType.JSON);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public JSONObject request;

    @Parameterized.Parameter(value = 2)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection fields() {
        prepareVCards();
        Object[][] data = new Object[][]{
                {"Float вместо массива Ids", getRequest(getIds(2.13f)),
                        new Api5Error(8000,
                                Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                                Path.path(DeleteRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS))},
                {"String вместо массива Ids", getRequest(getIds("asdf")),
                        new Api5Error(8000,
                                Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                                Path.path(DeleteRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS))},
                {"String в массиве Ids", getRequest(getIds(Arrays.asList(cardId2, "asdf"))),
                        new Api5Error(8000,
                                Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                                Path.path(DeleteRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS))},
                {"Массив в массиве Ids", getRequest(getIds(Arrays.asList(cardId2, singletonList(cardId1)))),
                        new Api5Error(8000,
                                Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                                Path.path(DeleteRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS))}
        };
        return Arrays.asList(data);
    }

    private static void prepareVCards() {
        log.info("Создадим кампанию и визитки");
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
        //workaround для создания кампаний в параметризованном тесте
        api.userSteps.campaignSteps().removeCampaignsFromQueue(Arrays.asList(campaignId));

        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(campaignId)
                .withCompanyName("Кампания для визитки 1");
        cardId1 = api.userSteps.vCardsSteps().vCardsAdd(item).get(0);
        item = new VCardAddMap().defaultContacts().withCampaignId(campaignId)
                .withCompanyName("Кампания для визитки 2");
        cardId2 = api.userSteps.vCardsSteps().vCardsAdd(item).get(0);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3979")
    public void fieldTypesTest() {
        api.userSteps.vCardsSteps().shouldGetVCardErrorJsonOn(
                Action.DELETE,
                request,
                expectedError
        );
    }

    @AfterClass
    public static void putCampaignToRemove() {
        //workaround для корректроного создания кампаний в параметризованном тесте
        api.userSteps.campaignSteps().putCampaignToQueue(singleClient, campaignId);
    }

    private static JSONObject getRequest(Object selectCriteria) {
        JSONObject request = new JSONObject();
        if (selectCriteria != null) {
            request.put(StringUtils.capitalize(GetRequestMap.SELECTION_CRITERIA), selectCriteria);
        }

        return request;
    }

    private static JSONObject getIds(Object idArray) {
        JSONObject ids = new JSONObject();
        ids.put(StringUtils.capitalize(IdsCriteriaMap.IDS), idArray);
        return ids;
    }
}
