package ru.yandex.autotests.directapi.vcards.delete;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.errors.Path;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.vcards.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 02.06.15.
 */
@Aqua.Test
@Features(VCardsFeatures.DELETE)
public class DeleteVCardsNegativeSoapTest {

    private static String login = VCardsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().protocol(ProtocolType.SOAP).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareVCards() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3980")
    public void noRequiredIdsTest() {
        api.as(login);
        api.userSteps.vCardsSteps().shouldGetVCardErrorOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(
                                new IdsCriteriaMap().withIds()),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        Path.path(DeleteRequestMap.SELECTION_CRITERIA))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3981")
    public void emptySelectionCriteriaTest() {
        api.userSteps.vCardsSteps().shouldGetVCardErrorOn(
                "Результат удаления не соответствует ожидаемому",
                Action.DELETE,
                new DeleteRequestMap(),
                new Api5Error(
                        8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        Path.path(DeleteRequestMap.SELECTION_CRITERIA))
        );
    }
}
