package ru.yandex.autotests.directapi.vcards.delete;

import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.errors.Path;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.vcards.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 25.07.14.
 */
@Aqua.Test
@Features(VCardsFeatures.DELETE)
@Tag(TagDictionary.TRUNK)
public class DeleteVCardsNegativeTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static LogSteps log = LogSteps.getLogger(DeleteVCardsNegativeTest.class);
    private static String login = VCardsLogins.SINGLE_CLIENT;
    private static String agency = VCardsLogins.AGENCY_VCARDS;
    private static String subClient = VCardsLogins.SUBCLIENT_VCARDS;
    private static long cardToDelete;
    private static long cardId1;
    private static long cardId2;
    private static long cardId3;
    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareVCards() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(subClient);
        //Подготовим кампании и визитки
        api.as(agency);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(subClient);
        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(campaignId);
        cardToDelete = api.userSteps.vCardsSteps().vCardsAdd(subClient, item.withCity("Урюпинск")).get(0);
        cardId1 = api.userSteps.vCardsSteps().vCardsAdd(subClient, item.withCity("Раменское")).get(0);
        cardId2 = api.userSteps.vCardsSteps().vCardsAdd(subClient, item.withCity("Солнечногорск")).get(0);
        cardId3 = api.userSteps.vCardsSteps().vCardsAdd(subClient, item.withCity("Рязань")).get(0);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3982")
    public void nonExistingVCardTest() {
        api.as(login);
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.DELETE,
                getDeleteRequest(38497246L),
                ExpectedResult.errors(new Notification(8800))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3983")
    public void alreadyDeletedVCardTest() {
        api.as(agency);
        api.userSteps.vCardsSteps().vCardsDelete(subClient, cardToDelete);
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.DELETE,
                subClient,
                getDeleteRequest(cardToDelete),
                ExpectedResult.errors(new Notification(8800))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3984")
    public void notOwnedVCardTest() {
        api.as(login);
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.DELETE,
                getDeleteRequest(cardId1),
                ExpectedResult.errors(new Notification(8800))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3985")
    public void duplicateVCardIDsTest() {
        //https://st.yandex-team.ru/DIRECT-34373
        api.as(agency);
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.DELETE,
                subClient,
                getDeleteRequest(cardId2, cardId2),
                ExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.VCARD_IN_DETAILS, cardId2)),
                ExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.VCARD_IN_DETAILS, cardId2)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3986")
    public void negativeVCardIDsTest() {
        api.as(login);
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.DELETE,
                getDeleteRequest(-5L),
                ExpectedResult.errors(new Notification(8800))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3987")
    public void fewInvalidIdsTest() {
        api.as(login);
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.DELETE,
                getDeleteRequest(-5L, 38497246L, 38497247L),
                ExpectedResult.errors(new Notification(8800)),
                ExpectedResult.errors(new Notification(8800)),
                ExpectedResult.errors(new Notification(8800))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3988")
    public void fewIdsSomeInvalidTest() {
        api.as(agency);
        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.DELETE,
                subClient,
                getDeleteRequest(-5L, cardId3, 38497247L),
                ExpectedResult.errors(new Notification(8800)),
                ExpectedResult.success(cardId3),
                ExpectedResult.errors(new Notification(8800))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3990")
    public void noRequiredIdsTest() {
        api.as(login);
        api.userSteps.vCardsSteps().shouldGetVCardErrorOn(
                Action.DELETE,
                getDeleteRequest(),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        Path.path(DeleteRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS), 1L)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3991")
    public void emptySelectionCriteriaTest() {
        api.as(subClient);
        api.userSteps.vCardsSteps().shouldGetVCardErrorOn(
                "Результат удаления не соответствует ожидаемому",
                Action.DELETE,
                new DeleteRequestMap(),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        Path.path(DeleteRequestMap.SELECTION_CRITERIA))
        );
    }

    @Test
    public void moreThanMaxIdsInSelectionCriteria() {
        api.as(login);
        Long[] ids = new Long[IdsCriteriaMap.VCARDS_IDS_MAX_LENGTH + 1];
        Arrays.fill(ids, 0L);
        api.userSteps.vCardsSteps().shouldGetVCardErrorOn(
                "Результат удаления не соответствует ожидаемому",
                Action.DELETE,
                getDeleteRequest(ids),
                new Api5Error(4001,
                        Api5ErrorDetailsJava.ENABLE_DELETE_NO_MORE_VCARDS_FOR_OPERATION,
                        IdsCriteriaMap.VCARDS_IDS_MAX_LENGTH)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3989")
    public void vCardAssignedToBannerTest() {
        log.info("Создадим визитку привязанную к баннеру");
        api.as(login);
        Long campaignWithBanner = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignWithBanner);
        Long vcardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignWithBanner);
        api.userSteps.adsSteps().addAd(
                new AdAddItemMap().withTextAd(new TextAdAddMap()
                        .defaultTextAd().withVCardId(vcardId))
                        .withAdGroupId(adGroupId), login);

        api.userSteps.vCardsSteps().shouldGetResultOn(
                Action.DELETE,
                login,
                getDeleteRequest(vcardId),
                ExpectedResult.errors(new Notification(6000, Api5ErrorDetailsJava.VCARD_IS_IN_USAGE))
        );
    }

    private DeleteRequestMap getDeleteRequest(Long... ids) {
        return new DeleteRequestMap()
                .withSelectionCriteria(
                        new IdsCriteriaMap().withIds(ids));
    }
}
