package ru.yandex.autotests.directapi.vcards.delete;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.contains;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 09.06.14.
 */
@Aqua.Test
@Features(VCardsFeatures.DELETE)
@Tag(TagDictionary.TRUNK)
public class DeleteVCardsPositiveTest {
    private static LogSteps log = LogSteps.getLogger(DeleteVCardsPositiveTest.class);

    private static String login = VCardsLogins.SINGLE_CLIENT;
    private static long campaignID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareVCard(){
        campaignID = api.as(login).userSteps.campaignSteps().addDefaultTextCampaign(login);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3992")
    public void deleteSingleVCardTest(){
        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(campaignID)
                .withCompanyName("Кампания с визиткой для удаления 0");
        List<Long> list = api.as(login).userSteps.vCardsSteps().vCardsAdd(item);
        long vCardId = list.get(0);

        List<Long> deletedCards = api.as(login).userSteps.vCardsSteps().vCardsDelete(vCardId);

        assertThat("наличие ID удаленной визитки в ответе", deletedCards, contains(vCardId));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3993")
    public void deleteMultipleVCardsTest(){
        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(campaignID)
                .withCompanyName("Кампания с визиткой для удаления 1");
        long firstVCardId = api.as(login).userSteps.vCardsSteps().vCardsAdd(item).get(0);
        item.withCompanyName("Кампания с визиткой для удаления 2");
        long secondVCardId = api.as(login).userSteps.vCardsSteps().vCardsAdd(item).get(0);

        List<Long> deletedCards = api.as(login).userSteps.vCardsSteps().vCardsDelete(secondVCardId, firstVCardId);

        assertThat("наличие ID удаленной визитки в ответе", deletedCards, contains(secondVCardId, firstVCardId));
    }
}
