package ru.yandex.autotests.directapi.vcards.delete;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.errors.Path;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.vcards.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 16.12.14.
 */
@Aqua.Test
@Features(VCardsFeatures.DELETE)
@Stories(ApiStories.UNITS)
public class DeleteVCardsUnitsTest {

    private static final String singleClient = VCardsLogins.CLIENT_UNITS_DELETE;

    private static final int DELETE_COST = 10;
    private static final int ITEM_COST_ON_DELETE = 0;
    private static final int DELETE_FAULT_COST = 20;
    private static final int GENERAL_FAULT_COST = 50;

    private static long campaignID;
    private static long vCard1;
    private static long vCard2;
    private static long vCard3;
    private static long vCard4;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);


    //fakeClearClientSpentUnits
    //fakeClientUnitsBalance
    //fakeWithdrawClientUnits

    @BeforeClass
    public static void prepareVCards() {
        //reset client units
        api.as(Logins.SUPER_LOGIN).userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);

        campaignID = api.as(singleClient).userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
        VCardAddMap item = new VCardAddMap().shortContacts().withCampaignId(campaignID).withCompanyName("Компания 1");
        vCard1 = api.as(singleClient).userSteps.vCardsSteps().vCardsAdd(item).get(0);
        item.withCompanyName("Компания 2");
        vCard2 = api.as(singleClient).userSteps.vCardsSteps().vCardsAdd(item).get(0);
        item.withCompanyName("Компания 3");
        vCard3 = api.as(singleClient).userSteps.vCardsSteps().vCardsAdd(item).get(0);
        item.withCompanyName("Компания 4");
        vCard4 = api.as(singleClient).userSteps.vCardsSteps().vCardsAdd(item).get(0);
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3998")
    public void deleteSingleVCardCostTest() {
        int unitsBefore = api.as(Logins.SUPER_LOGIN).userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);
        api.as(singleClient).userSteps.vCardsSteps().vCardsDelete(vCard4);
        int unitsAfter = api.as(Logins.SUPER_LOGIN).userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);

        assertThat("стоимость удаления одной визитки", (unitsBefore - unitsAfter),
                equalTo(DELETE_COST + ITEM_COST_ON_DELETE));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3999")
    public void deleteSeveralVCardsCostTest() {
        //https://st.yandex-team.ru/DIRECT-39224
        int unitsBefore = api.as(Logins.SUPER_LOGIN).userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);
        api.as(singleClient).userSteps.vCardsSteps().vCardsDelete(vCard1, vCard2);
        int unitsAfter = api.as(Logins.SUPER_LOGIN).userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);

        assertThat("стоимость удаления двух визиток", (unitsBefore - unitsAfter),
                equalTo(DELETE_COST + 2 * ITEM_COST_ON_DELETE));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4000")
    public void deleteNonExistingVCardCostTest() {
        //https://st.yandex-team.ru/DIRECT-39224
        int unitsBefore = api.as(Logins.SUPER_LOGIN).userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);
        api.as(singleClient).userSteps.vCardsSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap().withIds(12345L)),
                ExpectedResult.errors(new Notification(8800)));
        int unitsAfter = api.as(Logins.SUPER_LOGIN).userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);

        assertThat("стоимость ошибки при удалении визитки", (unitsBefore - unitsAfter),
                equalTo(DELETE_COST + DELETE_FAULT_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3996")
    public void addFewVCardsOneInvalidItemTest() {
        int unitsBefore = api.as(Logins.SUPER_LOGIN).userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);
        api.as(singleClient).userSteps.vCardsSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap().withIds(vCard3, 12345L)),
                ExpectedResult.success(),
                ExpectedResult.errors(new Notification(8800)));
        int unitsAfter = api.as(Logins.SUPER_LOGIN).userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);

        assertThat("стоимость ошибки при удалении нескольких визиток", (unitsBefore - unitsAfter),
                equalTo(DELETE_COST + ITEM_COST_ON_DELETE + DELETE_FAULT_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3997")
    public void noRequiredFieldTest() {
        int unitsBefore = api.as(Logins.SUPER_LOGIN).userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);
        api.as(singleClient).userSteps.vCardsSteps().shouldGetVCardErrorOn(
                Action.DELETE,
                new DeleteRequestMap(),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        Path.path(DeleteRequestMap.SELECTION_CRITERIA)));
        int unitsAfter = api.as(Logins.SUPER_LOGIN).userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);

        assertThat("стоимость ошибки при удалении визитки", (unitsBefore - unitsAfter), equalTo(GENERAL_FAULT_COST));
    }
}
