package ru.yandex.autotests.directapi.vcards.error53;

import com.yandex.direct.api.v5.vcards.VCardFieldEnum;
import org.junit.Ignore;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.vcards.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.GetRequestMap;
import ru.yandex.autotests.directapi.test.error53.AbstractError53Test;
import ru.yandex.autotests.directapi.test.error53.Error53TestConfig;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-67918")
@Features(ApiFeatures.ERROR53)
@Description("Тестирует ошибку №53")
@Ignore("https://st.yandex-team.ru/DIRECT-65872")
public final class Error53Test extends AbstractError53Test {
    public Error53Test() {
        super(
                new Error53TestConfig.Builder()
                        .withServiceName(ServiceNames.VCARDS)
                        .withGetAction(Action.GET)
                        .withGetBean(
                                new GetRequestMap()
                                        .withFieldNames(VCardFieldEnum.ID))
                        .withNotGetAction(Action.DELETE)
                        .withNotGetBean(
                                new DeleteRequestMap()
                                        .withSelectionCriteria(
                                                new IdsCriteriaMap().withIds(-1L)))
                        .build());
    }
}
