package ru.yandex.autotests.directapi.vcards.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.vcards.VCardGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by samedy on 14.01.16.
 */
@Aqua.Test
@RunWith(Parameterized.class)
@Features(VCardsFeatures.GET)
@Description("Проверка формата WorkTime в VCards")
@Issue("https://st.yandex-team.ru/DIRECT-49981")
public class GetVCardWorkTimeTest {

    private static LogSteps log = LogSteps.getLogger(GetVCardWorkTimeTest.class);

    private static final String SINGLE_CLIENT = VCardsLogins.SINGLE_CLIENT;

    private static Long campaignId;
    public Long vCardId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SINGLE_CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(0)
    public String workTime;

    @Parameterized.Parameters(name = "workTime = {0}")
    public static Collection mapPoints() {
        Object[][] data = new Object[][]{
                {"0;6;00;00;00;00"},
                {"0;6;0;15;08;15"},
                {"0;6;00;15;8;15"},
                {"0;3;10;0;18;0;4;6;08;00;18;00"},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SINGLE_CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(SINGLE_CLIENT);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createVcard() {
        vCardId = api.userSteps.vCardsSteps().vCardsAdd(new VCardAddMap()
                .defaultContacts()
                .withCampaignId(campaignId)
                .withWorkTime(workTime)).get(0);
    }

    @Test
    public void workTimeTest() {

        List<VCardGetItem> vCards = api.userSteps.vCardsSteps().vCardsGet(vCardId);
        assumeThat("вернулась информация о визитке", vCards.size(), equalTo(1));
        assertThat("значение WorkTime равно ожидаемому", vCards.get(0).getWorkTime(), equalTo(workTime));
    }
}
