package ru.yandex.autotests.directapi.vcards.get;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.vcards.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 14.10.14.
 */
@Aqua.Test
@Features(VCardsFeatures.GET)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetVCardsByAssistantNegativeTest {
    private static LogSteps log = LogSteps.getLogger(GetVCardsByAssistantNegativeTest.class);

    private static long vCardId;
    private static long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String creator;

    @Parameterized.Parameter(value = 1)
    public String operator;

    @Parameterized.Parameter(value = 2)
    public String client;

    @Parameterized.Parameters(name = "creator = {0}, operator = {1}, client = {2}")
    public static Collection logins() {
        Object[][] data = new Object[][]{
                {VCardsLogins.AGENCY_VCARDS_2, VCardsLogins.AGENCY_VCARDS_3, VCardsLogins.SUBCLIENT_VCARDS_3},
        };
        return Arrays.asList(data);
    }

    @Before
    public void prepareVCards(){
        log.info("Создадим кампании и визитки");
        api.as(creator);
        campaignId = api.as(creator).userSteps.campaignSteps().addDefaultTextCampaign(client);

        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(campaignId);
        vCardId = api.userSteps.vCardsSteps().vCardsAdd(client, item).get(0);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4001")
    public void getVCardByAssistantTest(){
        api.as(operator);
        api.userSteps.vCardsSteps().shouldGetVCardErrorOn(Action.GET, client,
                new GetRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(vCardId)),
                new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN));
    }
}
