package ru.yandex.autotests.directapi.vcards.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.vcards.VCardGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardGetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer.beanconstraint.BeanConstraints;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 17.07.14.
 */
@Aqua.Test
@Features(VCardsFeatures.GET)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetVCardsByAssistantTest {
    private static final String AGENCY1 = VCardsLogins.AGENCY_VCARDS;
    private static final String AGENCY2 = VCardsLogins.AGENCY_YE_DEFAULT;
    private static final String MANAGER = Logins.MANAGER_DEFAULT;

    private static long vCardId;
    private static long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String creator;

    @Parameterized.Parameter(value = 1)
    public String operator;

    @Parameterized.Parameter(value = 2)
    public String client;

    @Parameterized.Parameters(name = "creator = {0}, operator = {1}, client = {2}")
    public static Collection logins() {
        Object[][] data = new Object[][]{
                {AGENCY1, AGENCY1, VCardsLogins.SUBCLIENT_VCARDS},
                {MANAGER, MANAGER, VCardsLogins.SERVICED_CLIENT_VCARDS},
                {MANAGER, AGENCY2, Logins.CLIENT_FREE_YE_DEFAULT}
                // DIRECT-64601 в API5 при наличии агентства у клиента
                // под менеджером создаются агентские кампании

        };
        return Arrays.asList(data);
    }

    @Before
    public void prepareVCards(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY1);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY2);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(MANAGER);
        //Создадим кампании и визитки
        api.as(creator);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(campaignId);
        vCardId = api.userSteps.vCardsSteps().vCardsAdd(client, item).get(0);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4002")
    public void getVCardByAssistantTest(){
        api.as(operator);
        List<VCardGetItem> vCards = api.userSteps.vCardsSteps().vCardsGet(client, vCardId);

        assertThat("вернулся набор визиток", vCards.size(), greaterThan(0));
        assertThat("получена корректная визитка", vCards.toArray()[0],
                beanDifferV5(
                        new VCardGetMap()
                                .defaultContacts()
                                .withCampaignId(campaignId)
                                .getBean()
                ).fields(new BeanConstraints().ignore(VCardGetMap.EXTRA_MESSAGE, VCardGetMap.ID, VCardGetMap.POINT_ON_MAP))
        );
    }
}
