package ru.yandex.autotests.directapi.vcards.get;

import java.util.List;

import com.yandex.direct.api.v5.vcards.VCardGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 05.06.14.
 */
@Aqua.Test
@Features(ApiFeatures.BUG)
@Description("Баг только на ТС DIRECT-41157")
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.BUG)
public class GetVCardsByClientTest {
    private static LogSteps log = LogSteps.getLogger(GetVCardsByClientTest.class);

    private static String srvClient = VCardsLogins.SERVICED_CLIENT_VCARDS;
    private static long firstCardId;
    private static long secondCardId;
    private static long thirdCardId;

    private static long anotherVCardId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().wsdl(APIPort_PortType.class);//.as(singleClient);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareVCards() {
        log.info("Создадим кампании и визитки");
        Long campaignId =
                api.as(Logins.SUPER_LOGIN, srvClient).userSteps.campaignSteps().addDefaultTextCampaign(srvClient);
        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(campaignId)
                .withCompanyName("Кампания для визитки 1");
        firstCardId = api.userSteps.vCardsSteps().vCardsAdd(item).get(0);
        item.withCompanyName("Кампания для визитки 2");
        secondCardId = api.userSteps.vCardsSteps().vCardsAdd(item).get(0);
        item.withCompanyName("Кампания для визитки 3");
        thirdCardId = api.userSteps.vCardsSteps().vCardsAdd(item).get(0);

        Long anotherCampaignID = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(srvClient);
        item = new VCardAddMap().defaultContacts()
                .withCompanyName("Кампания для визитки 0")
                .withCampaignId(anotherCampaignID);
        anotherVCardId = api.userSteps.vCardsSteps().vCardsAdd(item).get(0);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4003")
    public void getSingleVCardTest() {
        List<VCardGetItem> vCards = api.userSteps.vCardsSteps().vCardsGet(secondCardId);

        assertThat("вернулся корректный набор визиток",
                extract(vCards, on(VCardGetItem.class).getId()),
                contains(secondCardId)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4004")
    public void getMultipleVCardsTest() {
        List<VCardGetItem> vCards = api.userSteps.vCardsSteps().vCardsGet(firstCardId, secondCardId, thirdCardId);

        assertThat("Вернулся некорректный набор визиток",
                extract(vCards, on(VCardGetItem.class).getId()),
                contains(firstCardId, secondCardId, thirdCardId)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4005")
    public void getMultipleVCardsUnsortedIdsTest() {
        List<VCardGetItem> vCards = api.userSteps.vCardsSteps().vCardsGet(secondCardId, firstCardId, thirdCardId);

        assertThat("Вернулся некорректный набор визиток",
                extract(vCards, on(VCardGetItem.class).getId()),
                containsInAnyOrder(secondCardId, firstCardId, thirdCardId)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4006")
    public void getVCardsFromDifferentCampaignTest() {
        List<VCardGetItem> vCards = api.userSteps.vCardsSteps().vCardsGet(firstCardId, anotherVCardId);

        assertThat("Вернулся некорректный набор визиток",
                extract(vCards, on(VCardGetItem.class).getId()),
                contains(firstCardId, anotherVCardId)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4007")
    public void getVCardsDuplicateIDsTest() {
        List<VCardGetItem> vCards = api.userSteps.vCardsSteps().vCardsGet(firstCardId, firstCardId);

        assertThat("Вернулся некорректный набор визиток",
                extract(vCards, on(VCardGetItem.class).getId()),
                contains(firstCardId)
        );
    }

}
