package ru.yandex.autotests.directapi.vcards.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.vcards.VCardFieldEnum;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.vcards.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Arrays.asList;
import static java.util.Collections.singletonList;
import static java.util.stream.Collectors.joining;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by chicos on 22.08.14.
 */
@Aqua.Test
@Features(VCardsFeatures.GET)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetVCardsFieldNamesNegativeTest {
    private static LogSteps log = LogSteps.getLogger(GetVCardsFieldNamesNegativeTest.class);

    private static String login = VCardsLogins.SINGLE_CLIENT_2;

    private static Long campaignId;
    private static long cardId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String[] fieldNames;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection fieldNames() {
        prepareVCards();
        Object[][] data = new Object[][]{
                {"Спецсимволы в имени поля", new String[]{"<InvalidNode/>"}},
                {"Пустая строка", new String[]{""}},
                {"Поле с маленькой буквы", new String[]{"street"}},
                {"Несуществующее поле", new String[]{"NonExistingField"}},
                {"Корректное и несуществующее поля", new String[]{"NonExistingField", "Phone"}}
        };
        return asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4011")
    public void invalidFieldNamesTest() {
        api.userSteps.vCardsSteps().shouldGetVCardErrorOn(
                "Ожидалась другая ошибка при некорректных FieldNames",
                Action.GET,
                new GetRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(cardId))
                        .withFieldNames(fieldNames),
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        path(GetRequestMap.FIELD_NAMES),
                        Arrays.stream(VCardFieldEnum.values()).map(VCardFieldEnum::value).collect(joining(", ")))
        );
    }

    @AfterClass
    public static void putCampaingToRemove(){
        //workaround для корректроного создания кампаний в параметризованном тесте
        api.userSteps.campaignSteps().putCampaignToQueue(login, campaignId);
    }

    @BeforeClass
    public static void prepareVCards() {
        log.info("Создадим кампанию и визитку");
        campaignId = api.as(login).userSteps.campaignSteps().addDefaultTextCampaign(login);

        //workaround для создания кампаний в параметризованном тесте
        api.userSteps.campaignSteps().removeCampaignsFromQueue(singletonList(campaignId));

        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(campaignId)
                .withCompanyName("Кампания для визитки 1");
        cardId = api.as(login).userSteps.vCardsSteps().vCardsAdd(item).get(0);
    }
}
