package ru.yandex.autotests.directapi.vcards.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.vcards.VCardFieldEnum;
import org.junit.AfterClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.model.api5.vcards.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 17.07.14.
 */
@Aqua.Test
@Features(VCardsFeatures.GET)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetVCardsLimitOffsetNegativeTest {
    private static LogSteps log = LogSteps.getLogger(GetVCardsLimitOffsetNegativeTest.class);

    private static String login = VCardsLogins.SINGLE_CLIENT_2;

    private static Long campaignId;
    private static long firstCardId;
    private static long secondCardId;
    private static long thirdCardId;
    private static long fourthCardId;
    private static long fifthCardId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public Long limit;

    @Parameterized.Parameter(value = 1)
    public Long offset;

    @Parameterized.Parameter(value = 2)
    public Long[] vCardIds;

    @Parameterized.Parameter(value = 3)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "limit = {0}, offset = {1}")
    public static Collection limitsAndOffsets() {
        prepareVCards();
        Long[] defaultVCardIds = new Long[]{firstCardId, secondCardId, thirdCardId, fourthCardId, fifthCardId};
        Object[][] data = new Object[][]{
                {0L, 2L, defaultVCardIds,
                        new Api5Error(4002, Api5ErrorDetails.LIMIT_MUST_BE_MORE_THAN_0)},
                {0L, null, defaultVCardIds,
                        new Api5Error(4002, Api5ErrorDetails.LIMIT_MUST_BE_MORE_THAN_0)},
                {-2l, null, defaultVCardIds,
                        new Api5Error(4002, Api5ErrorDetails.LIMIT_MUST_BE_MORE_THAN_0)},
                {-6l, null, defaultVCardIds,
                        new Api5Error(4002, Api5ErrorDetails.LIMIT_MUST_BE_MORE_THAN_0)},
                {-5l, null, defaultVCardIds,
                        new Api5Error(4002, Api5ErrorDetails.LIMIT_MUST_BE_MORE_THAN_0)},
                {null, -1l, defaultVCardIds,
                        new Api5Error(4002, Api5ErrorDetails.OFFSET_MUST_BE_MORE_OR_EQUAL_THAN_0)},
                {null, -6l, defaultVCardIds,
                        new Api5Error(4002, Api5ErrorDetails.OFFSET_MUST_BE_MORE_OR_EQUAL_THAN_0)},
                {2l, -3l, defaultVCardIds,
                        new Api5Error(4002, Api5ErrorDetails.OFFSET_MUST_BE_MORE_OR_EQUAL_THAN_0)},
                {-2l, -1l, defaultVCardIds,
                        new Api5Error(4002, Api5ErrorDetails.LIMIT_MUST_BE_MORE_THAN_0)}
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4013")
    public void getVCardLimitOffsetTest() {
        //https://st.yandex-team.ru/DIRECT-34422
        api.as(login).userSteps.vCardsSteps().shouldGetVCardErrorOn(
                Action.GET,
                new GetRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(vCardIds))
                        .withFieldNames(VCardFieldEnum.class.getEnumConstants())
                        .withPage(new LimitOffsetMap()
                                .withLimit(limit)
                                .withOffset(offset)),
                expectedError
        );
    }

    @AfterClass
    public static void putCampaingToRemove(){
        //workaround для корректроного создания кампаний в параметризованном тесте
        api.userSteps.campaignSteps().putCampaignToQueue(login, campaignId);
    }

    private static void prepareVCards() {
        log.info("Создадим кампании и визитки");
        campaignId = api.as(login).userSteps.campaignSteps().addDefaultTextCampaign(login);

        //workaround для создания кампаний в параметризованном тесте
        api.userSteps.campaignSteps().removeCampaignsFromQueue(Arrays.asList(campaignId));

        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(campaignId)
                .withCompanyName("Кампания для визитки 1");
        firstCardId = api.as(login).userSteps.vCardsSteps().vCardsAdd(item).get(0);

        item.withCompanyName("Кампания для визитки 2");
        secondCardId = api.as(login).userSteps.vCardsSteps().vCardsAdd(item).get(0);

        item.withCompanyName("Кампания для визитки 3");
        thirdCardId = api.as(login).userSteps.vCardsSteps().vCardsAdd(item).get(0);

        item.withCompanyName("Кампания для визитки 4");
        fourthCardId = api.as(login).userSteps.vCardsSteps().vCardsAdd(item).get(0);

        item.withCompanyName("Кампания для визитки 5");
        fifthCardId = api.as(login).userSteps.vCardsSteps().vCardsAdd(item).get(0);
    }
}
