package ru.yandex.autotests.directapi.vcards.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.vcards.VCardFieldEnum;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.junit.AfterClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.vcards.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardGetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static java.util.stream.Collectors.joining;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by chicos on 09.12.14.
 */
@Aqua.Test
@Features(VCardsFeatures.GET)
@Tag(TagDictionary.TRUNK)
@Stories(ApiStories.JSON5)
@RunWith(Parameterized.class)
public class GetVCardsNegativeJsonTest {
    private static LogSteps log = LogSteps.getLogger(GetVCardsNegativeJsonTest.class);

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT;
    private static Long campaignId;

    private static long cardId1;
    private static long cardId2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient).protocol(ProtocolType.JSON);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public JSONObject request;

    @Parameterized.Parameter(value = 2)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection fields() {
        prepareVCards();
        Object[][] data = new Object[][]{
                {"Float вместо массива Ids", getRequest(getIds(2.13f),
                        singletonList(StringUtils.capitalize(VCardGetMap.COMPANY_NAME))),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                                path(GetRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS))},
                {"String вместо массива Ids", getRequest(getIds("asdf"),
                        singletonList(StringUtils.capitalize(VCardGetMap.COMPANY_NAME))),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                                path(GetRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS))},
                {"String в массиве Ids", getRequest(getIds(Arrays.asList(cardId2, "asdf")),
                        singletonList(StringUtils.capitalize(VCardGetMap.COMPANY_NAME))),
                        new Api5Error(8000,
                                Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                                path(GetRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS))},
                {"Массив в массиве Ids", getRequest(getIds(Arrays.asList(cardId2, singletonList(cardId1))),
                        singletonList(StringUtils.capitalize(VCardGetMap.COMPANY_NAME))),
                        new Api5Error(8000,
                                Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                                path(GetRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS))},
                {"Integer вместо набора FieldNames", getRequest(getIds(Arrays.asList(cardId2, cardId1)), 12345),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                                path(GetRequestMap.FIELD_NAMES))},
                {"Float в наборе FieldNames",
                        getRequest(getIds(Arrays.asList(cardId2, cardId1)), Arrays.asList(
                                StringUtils.capitalize(VCardGetMap.COMPANY_NAME),
                                path(VCardGetMap.PHONE),
                                2.13f)),
                        new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                                path(GetRequestMap.FIELD_NAMES),
                                Arrays.stream(VCardFieldEnum.values()).map(VCardFieldEnum::value).collect(joining(", ")))},
                {"Массив в наборе FieldNames",
                        getRequest(getIds(Arrays.asList(cardId2, cardId1)), Arrays.asList(
                                StringUtils.capitalize(VCardGetMap.COMPANY_NAME),
                                singletonList(StringUtils.capitalize(VCardGetMap.PHONE)))),
                        new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                                path(GetRequestMap.FIELD_NAMES),
                                Arrays.stream(VCardFieldEnum.values()).map(VCardFieldEnum::value).collect(joining(", ")))}
        };
        return Arrays.asList(data);
    }

    private static void prepareVCards() {
        log.info("Создадим кампанию и визитки");
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
        //workaround для создания кампаний в параметризованном тесте
        api.userSteps.campaignSteps().removeCampaignsFromQueue(singletonList(campaignId));

        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(campaignId)
                .withCompanyName("Кампания для визитки 1");
        cardId1 = api.userSteps.vCardsSteps().vCardsAdd(item).get(0);
        item = new VCardAddMap().defaultContacts().withCampaignId(campaignId)
                .withCompanyName("Кампания для визитки 2");
        cardId2 = api.userSteps.vCardsSteps().vCardsAdd(item).get(0);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4015")
    public void fieldTypesTest() {
        api.userSteps.vCardsSteps().shouldGetVCardErrorJsonOn(
                Action.GET,
                request,
                expectedError
        );
    }

    @AfterClass
    public static void putCampaingToRemove() {
        //workaround для корректроного создания кампаний в параметризованном тесте
        api.userSteps.campaignSteps().putCampaignToQueue(singleClient, campaignId);
    }

    private static JSONObject getRequest(Object selectCriteria, Object fieldNames) {
        JSONObject request = new JSONObject();
        if (selectCriteria != null) {
            request.put(StringUtils.capitalize(GetRequestMap.SELECTION_CRITERIA), selectCriteria);
        }
        if (fieldNames != null) {
            request.put(StringUtils.capitalize(GetRequestMap.FIELD_NAMES), fieldNames);
        }

        return request;
    }

    private static JSONObject getIds(Object idArray) {
        JSONObject ids = new JSONObject();
        ids.put(StringUtils.capitalize(IdsCriteriaMap.IDS), idArray);
        return ids;
    }
}
