package ru.yandex.autotests.directapi.vcards.get;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.vcards.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;


/**
 * Created by chicos on 02.06.15.
 */
@Aqua.Test
@Features(VCardsFeatures.GET)
public class GetVCardsNegativeSoapTest {
    private static LogSteps log = LogSteps.getLogger(GetVCardsNegativeSoapTest.class);

    private static String singleClient = VCardsLogins.SINGLE_CLIENT;

    private static long cardIdSingle;

    @ClassRule
    public static ApiSteps api = new ApiSteps().protocol(ProtocolType.SOAP).as(singleClient);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareVCards() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        //Создадим кампании и визитки
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(campaignId)
                .withCompanyName("Кампания для визитки 1");
        cardIdSingle = api.userSteps.vCardsSteps().vCardsAdd(item).get(0);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4016")
    @Ignore("DIRECT-70630")
    public void noRequiredIdTest() {
        api.userSteps.vCardsSteps().shouldGetVCardErrorOn(
                "Вернулся неожиданный результат",
                Action.GET,
                new GetRequestMap()
                        .withAllFieldNames()
                        .withSelectionCriteria(new IdsCriteriaMap()),
                new Api5Error(
                        8000,
                        Api5ErrorDetailsJava.MISSING_VALUE_OR_NULL,
                        path(GetRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4017")
    public void noFieldNamesTest() {
        api.userSteps.vCardsSteps().shouldGetVCardErrorOn(
                "Вернулся неожиданный результат",
                Action.GET,
                new GetRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(cardIdSingle)),
                new Api5Error(
                        8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(GetRequestMap.FIELD_NAMES))
        );
    }
}
