package ru.yandex.autotests.directapi.vcards.get;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.vcards.VCardGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.vcards.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.contains;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 21.08.14.
 */
@Aqua.Test
@Features(VCardsFeatures.GET)
@Tag(TagDictionary.TRUNK)
public class GetVCardsNegativeTest {
    private static String singleClient = VCardsLogins.SINGLE_CLIENT;
    private static final int VCARDS_LIMIT_ON_GET = 10000;

    private static String agency = VCardsLogins.AGENCY_VCARDS;
    private static String subClient = VCardsLogins.SUBCLIENT_VCARDS;
    private static String subClient2 = VCardsLogins.SUBCLIENT_VCARDS_2;

    private static long cardIdSingle;

    private static long cardId1;
    private static long cardId2;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(singleClient);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareVCards() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        //Создадим кампании и визитки
        api.as(singleClient);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(campaignId)
                .withCompanyName("Кампания для визитки 1");
        cardIdSingle = api.userSteps.vCardsSteps().vCardsAdd(item).get(0);

        api.as(agency);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(subClient);
        item = new VCardAddMap().defaultContacts().withCampaignId(campaignId);
        cardId1 =
                api.userSteps.vCardsSteps().vCardsAdd(subClient, item.withCompanyName("Компания субклиента 1")).get(0);

        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(subClient2);
        item = new VCardAddMap().defaultContacts().withCampaignId(campaignId);
        cardId2 =
                api.userSteps.vCardsSteps().vCardsAdd(subClient2, item.withCompanyName("Компания субклиента 2")).get(0);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4018")
    public void noRequiredIdTest() {
        api.as(singleClient).userSteps.vCardsSteps().shouldGetVCardErrorOn(
                "Вернулся неожиданный результат",
                Action.GET,
                new GetRequestMap()
                        .withAllFieldNames()
                        .withSelectionCriteria(new IdsCriteriaMap()),
                new Api5Error(
                        8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(IdsCriteriaMap.IDS)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4019")
    public void noFieldNamesTest() {
        api.as(singleClient).userSteps.vCardsSteps().shouldGetVCardErrorOn(
                "Вернулся неожиданный результат",
                Action.GET,
                new GetRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(cardIdSingle)),
                new Api5Error(
                        8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(GetRequestMap.FIELD_NAMES))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4021")
    public void getVCardByAgencyForDifferentSubclientsTest() {
        api.as(agency);
        List<VCardGetItem> vCards = api.userSteps.vCardsSteps().vCardsGet(subClient, cardId1, cardId2);

        assertThat("вернулся корректный набор визиток",
                extract(vCards, on(VCardGetItem.class).getId()),
                contains(cardId1)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4020")
    public void vCardItemsOverLimitTest() {
        Long[] fakeIds = new Long[VCARDS_LIMIT_ON_GET + 1];
        Arrays.fill(fakeIds, 0, VCARDS_LIMIT_ON_GET + 1, 123456789L);
        api.as(singleClient).userSteps.vCardsSteps().shouldGetVCardErrorOn(
                "Вернулся неожиданный результат",
                Action.GET,
                new GetRequestMap()
                        .withAllFieldNames()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(fakeIds)),
                new Api5Error(4001,
                        Api5ErrorDetails.ARRAY_CANNOT_CONTAIN_MORE_THAN,
                        path(GetRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS),
                        VCARDS_LIMIT_ON_GET));
    }
}
