package ru.yandex.autotests.directapi.vcards.get;

import java.util.Collections;
import java.util.List;

import com.yandex.direct.api.v5.vcards.VCardFieldEnum;
import com.yandex.direct.api.v5.vcards.VCardGetItem;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AddressesRecord;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.vcards.MapPointMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardGetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;
import static org.junit.Assume.assumeThat;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;


/**
 * Created by hmepas on 15.02.2016
 */
@Aqua.Test
@Features(VCardsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-50784")
@Description("Проверяем, что при адресе для которого нет автоматически выбранных координат визитку можно получить методом get")
public class GetVCardsNullAddressAutoMapPoint {

    private static final String LOGIN = VCardsLogins.SINGLE_CLIENT;
    private static final MapPointMap MAP_POINT = new MapPointMap().point(37.962550f, 55.571451f, 37.831591f, 55.507682f, 38.112086f, 55.585542f).setPointScale(6);
    private static final String ADDRESS_STREET = "мкрн. Детский городок \"ЗиЛ\"";
    private static final String ADDRESS_CITY = "Лыткарино";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Test
    @Description("Get отдает визитку, для которой есть ручные координаты, но нет автоматически вычисленных")
    public void getVCardsNullAddressAutoMapPointSuccess() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();

        /*  Специальный адрес, для которого гео-кодер не может подобрать координаты.
            Если начнет подбирать, то тест потеряет смысл и придется
            придумывать другой адрес */
        VCardAddMap vCard = new VCardAddMap().defaultContacts().withCampaignId(campaignId)
                .withPointOnMap(MAP_POINT)
                .withStreet(ADDRESS_STREET)
                .withCity(ADDRESS_CITY)
                .withHouse(null);

        List<Long> vCardIds = api.userSteps.vCardsSteps().vCardsAdd(vCard);

        Long addressId = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).vCardSteps().getVCards(vCardIds.get(0)).getAddressId();
        AddressesRecord address = api.userSteps.getDirectJooqDbSteps().addressesSteps().getAddresses(addressId);
        assumeThat("в БД запись в таблице addresses имеет map_id_auto = null", address.getMapIdAuto(), nullValue());

        List<VCardGetItem> createdVCards = api.as(LOGIN).userSteps.vCardsSteps()
                .vCardsGet(Collections.singletonList(VCardFieldEnum.POINT_ON_MAP),vCardIds.toArray(new Long[1]));
        assertThat("Успешно получены координаты", createdVCards.get(0), beanDifferV5( new VCardGetMap().withPointOnMap(MAP_POINT).getBean() ));
    }

}
