package ru.yandex.autotests.directapi.vcards.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.vcards.VCardGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardGetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.beandiffer.beanconstraint.BeanConstraints;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 14.10.14.
 */
@Aqua.Test
@Features(VCardsFeatures.GET)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetVCardsRolesAccessAgencyTest {
    private static LogSteps log = LogSteps.getLogger(GetVCardsRolesAccessAgencyTest.class);

    private static final String agency = VCardsLogins.AGENCY_VCARDS_2;
    private static final String subclient = VCardsLogins.SUBCLIENT_VCARDS_4;

    private static long vCardId;
    private static long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameters(name = "operator = {0}")
    public static Collection logins() {
        Object[][] data = new Object[][]{
                {VCardsLogins.AGENCY_VCARDS_2_REP},
                {VCardsLogins.AGENCY_VCARDS_2_REP_CLIENTS},
                {Logins.SUPPORT},
                {Logins.MEDIA},
                {Logins.PLACER},
                {Logins.SUPER_READER}

        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareCampaign() {
        log.info("Создадим кампанию агентством");
        api.as(agency);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(subclient);
    }

    @Before
    public void prepareVCards() {
        log.info("Создадим визитку агентством");
        api.as(agency);
        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(campaignId);
        vCardId = api.userSteps.vCardsSteps().vCardsAdd(subclient, item).get(0);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4022")
    public void getVCardByRoleTest() {
        log.info("Запросим визитку ролью");
        api.as(operator);
        List<VCardGetItem> vCards = api.userSteps.vCardsSteps().vCardsGet(subclient, vCardId);

        assertThat("вернулся набор визиток", vCards.size(), greaterThan(0));
        assertThat("получена корректная визитка", vCards.toArray()[0],
                beanDifferV5(
                        new VCardGetMap()
                                .defaultContacts()
                                .withCampaignId(campaignId)
                                .getBean()
                ).fields(new BeanConstraints().ignore(VCardGetMap.EXTRA_MESSAGE, VCardGetMap.ID, VCardGetMap.POINT_ON_MAP))
        );
    }
}
