package ru.yandex.autotests.directapi.vcards.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.vcards.VCardGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardGetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.beandiffer.beanconstraint.BeanConstraints;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 09.10.14.
 */
@Aqua.Test
@Features(VCardsFeatures.GET)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetVCardsRolesAccessClientTest {
    private static LogSteps log = LogSteps.getLogger(GetVCardsRolesAccessClientTest.class);

    private static final String singleClient = VCardsLogins.SINGLE_CLIENT_3;

    private static long vCardId;
    private static long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String client;

    @Parameterized.Parameters(name = "operator = {0}")
    public static Collection logins() {
        Object[][] data = new Object[][]{
                {VCardsLogins.SINGLE_CLIENT_3_REP,
                        null},
                {Logins.SUPPORT,
                        singleClient},
                {Logins.PLACER,
                        singleClient},
                {Logins.MEDIA,
                        singleClient},
                {Logins.SUPER_READER,
                        singleClient}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareVCards() {
        log.info("Создадим кампанию и визитки пользователем");
        api.as(singleClient);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(campaignId);
        vCardId = api.userSteps.vCardsSteps().vCardsAdd(item).get(0);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4023")
    public void getVCardByRoleTest() {
        log.info("Запросим визитку ролью");
        api.as(operator);
        List<VCardGetItem> vCards;
        if (client != null){
            vCards = api.userSteps.vCardsSteps().vCardsGet(client, vCardId);
        }else {
            vCards = api.userSteps.vCardsSteps().vCardsGet(vCardId);
        }

        assertThat("вернулся набор визиток", vCards.size(), greaterThan(0));
        assertThat("получена корректная визитка", vCards.toArray()[0],
                beanDifferV5(
                        new VCardGetMap()
                                .defaultContacts()
                                .withCampaignId(campaignId)
                                .getBean()
                ).fields(new BeanConstraints().ignore(VCardGetMap.EXTRA_MESSAGE, VCardGetMap.ID, VCardGetMap.POINT_ON_MAP))
        );
    }
}
