package ru.yandex.autotests.directapi.vcards.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.vcards.VCardGetItem;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.emptyIterable;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 26.08.14.
 */
@Aqua.Test
@Features(VCardsFeatures.GET)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetVCardsSelectionCriteriaNegativeTest {
    private static LogSteps log = LogSteps.getLogger(GetVCardsSelectionCriteriaNegativeTest.class);

    private static String login = VCardsLogins.SINGLE_CLIENT;
    private static String anotherLogin = VCardsLogins.SINGLE_CLIENT_2;

    private static long firstCardId;
    private static long deletedVCard;

    private static long vCardOfDeletedCampaign;

    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String operator;

    @Parameterized.Parameter(value = 2)
    public Long[] vCardIds;

    @Parameterized.Parameter(value = 3)
    public Matcher expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection fieldNames() {
        prepareVCards();
        Object[][] data = new Object[][]{
                {"Удаленная визитка", login, new Long[]{deletedVCard}, emptyIterable()},
                {"Визитка удаленной кампании", login, new Long[]{vCardOfDeletedCampaign}, emptyIterable()},
                {"Визитка другого пользователя", anotherLogin, new Long[]{firstCardId}, emptyIterable()},
                {"Несуществующая визитка", login, new Long[]{38497248L}, emptyIterable()},
                {"Некорретный Id визитки", login, new Long[]{0l}, emptyIterable()},
                {"Корректный и некорректный Id визиток", login, new Long[]{firstCardId, -123l}, hasSize(1)}
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4024")
    public void negativeVCardIdTest() {
        List<VCardGetItem> vCards = api.as(operator).userSteps.vCardsSteps().vCardsGet(vCardIds);
        assertThat("вернулся корректный набор визиток", vCards, expectedResult);
    }

    @AfterClass
    public static void putCampaingToRemove(){
        //workaround для корректроного создания кампаний в параметризованном тесте
        api.userSteps.campaignSteps().putCampaignToQueue(login, campaignId);
    }

    private static void prepareVCards(){
        log.info("Создадим кампании и визитки");
        api.as(login);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(login);

        //workaround для создания кампаний в параметризованном тесте
        api.userSteps.campaignSteps().removeCampaignsFromQueue(Arrays.asList(campaignId));

        VCardAddMap item = new VCardAddMap().defaultContacts().withCampaignId(campaignId)
                .withCompanyName("Кампания для визитки 1");
        firstCardId = api.userSteps.vCardsSteps().vCardsAdd(item).get(0);
        item.withCompanyName("Кампания для визитки 2");
        deletedVCard = api.userSteps.vCardsSteps().vCardsAdd(item).get(0);
        api.userSteps.vCardsSteps().vCardsDelete(deletedVCard);

        Long campaignToDelete = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        item = new VCardAddMap().defaultContacts()
                .withCompanyName("Кампания для визитки 0")
                .withCampaignId(campaignToDelete);
        vCardOfDeletedCampaign = api.userSteps.vCardsSteps().vCardsAdd(item).get(0);
        api.userSteps.campaignSteps().campaignsDelete(campaignToDelete);
    }
}
