package ru.yandex.autotests.directapi.vcards.get;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.VCardsFeatures;
import ru.yandex.autotests.directapi.VCardsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.vcards.VCardAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 16.12.14.
 */
@Aqua.Test
@Features(VCardsFeatures.GET)
@Stories(ApiStories.UNITS)
public class GetVCardsUnitsTest {
    private static LogSteps log = LogSteps.getLogger(GetVCardsUnitsTest.class);

    private static final String singleClient = VCardsLogins.CLIENT_UNITS_GET;

    private static final int GET_COST = 15;
    private static final int ITEM_COST_ON_GET = 1;
    private static final int GET_FAULT_COST = 20;

    private static long campaignID;
    private static long vCard1;
    private static long vCard2;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareVCards() {
        //reset client units
        api.as(Logins.SUPER_LOGIN).userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);

        campaignID = api.as(singleClient).userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
        VCardAddMap item = new VCardAddMap().shortContacts().withCampaignId(campaignID).withCompanyName("Компания 1");
        vCard1 = api.as(singleClient).userSteps.vCardsSteps().vCardsAdd(item).get(0);
        item.withCompanyName("Компания 2");
        vCard2 = api.as(singleClient).userSteps.vCardsSteps().vCardsAdd(item).get(0);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4025")
    public void getSingleVCardCostTest() {
        int unitsBefore = api.as(Logins.SUPER_LOGIN).userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);
        api.as(singleClient).userSteps.vCardsSteps().vCardsGet(vCard1);
        int unitsAfter = api.as(Logins.SUPER_LOGIN).userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);

        assertThat("стоимость запроса одной визитки", (unitsBefore - unitsAfter), equalTo(GET_COST + ITEM_COST_ON_GET));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4026")
    public void getSeveralVCardsCostTest() {
        int unitsBefore = api.as(Logins.SUPER_LOGIN).userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);
        api.as(singleClient).userSteps.vCardsSteps().vCardsGet(vCard1, vCard2);
        int unitsAfter = api.as(Logins.SUPER_LOGIN).userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);

        assertThat("стоимость запроса двух визиток", (unitsBefore - unitsAfter), equalTo(GET_COST + 2 * ITEM_COST_ON_GET));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4027")
    public void getNonExistingVCardCostTest() {
        int unitsBefore = api.as(Logins.SUPER_LOGIN).userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);
        api.as(singleClient).userSteps.vCardsSteps().vCardsGet(1234l);
        int unitsAfter = api.as(Logins.SUPER_LOGIN).userSteps.clientFakeSteps().fakeClientUnitsBalance(singleClient);

        assertThat("стоимость ошибки при запросе визитки", (unitsBefore - unitsAfter), equalTo(GET_COST));
    }
}
