package ru.yandex.autotests.direct.bsapi;

import ru.yandex.autotests.direct.utils.BaseSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static ru.yandex.autotests.direct.bsapi.BsSteps.resolveDatabaseNumber;

/*
* todo javadoc
*/
public class BsDbSteps extends BaseSteps<String> {

    private static final String LOGIN = "root";
    private static final String PASS = "nimbula";

    public enum StatusModerate {
        NO("3"),
        YES("4");

        private String id;

        StatusModerate(String id) {
            this.id = id;
        }
    }

    @Step("BS db: Добавляем тестовую авторизацию в базу")
    public void setAuth() {
        executeUpdate("update s_customer set passport_id = NULL where nmb = 1");
        executeUpdate("update s_customer set passport_id = 4003608477 where nmb = 93");
    }

    @Step("BS db: Устанавливаем статус модерации {1} креативу {0}")
    public void setCreativeStatusModerate(Integer creativeNmb, StatusModerate status) {
        String sql = "update t_creative_version " +
                "set note='Промодерированный степами креатив', " +
                "moderation_request_date='2015-09-15 12:08:15.967'," +
                "status_nmb=" + status.id + "," +
                "moderation_date='2015-09-15 12:09:15.967'," +
                "moderation_info=''," +
                "expire_date='2025-01-01'," +
                "creative_moderation_request_version=1," +
                "user_id='B372FA37-4C71-4A64-80D1-B2D990F13453'," +
                "sub_version=2," +
                "lock_moderation_date='2015-09-15 12:09:37.347'," +
                "is_enabled=1" +
                "where creative_nmb=" + creativeNmb;
        executeUpdate(sql);
    }

    @Step
    public void increaseTCreativeIncrement(Integer value) {
        setNewIncrementValue("t_creative", value);
    }

    private void setNewIncrementValue(String tableName, Integer value) {
        // Не устанавливаем это значение автоматикой: это ломает подготовленные с помощью DIRECTKNOL-62 стенды
        //String sql = "DBCC checkident ('" + tableName + "')";
        //SQLWarning warn = getWarnings(st -> st.execute(sql));

        //Pattern pat = Pattern.compile("(\\d+)");
        //Matcher matcher = pat.matcher(warn.getMessage());
        //Integer seed = 0;
        //if (matcher.find()) {
        //    seed = Integer.valueOf(matcher.group(1));
        //} else {
        //    throw new BsStepsException("Ошибка при получении инкремента", new Error());
        //}
        //if (seed < value) {
        //    getWarnings(st -> st.execute("DBCC checkident ('" + tableName + "', reseed, " + (value + 100) + ")"));
        //}
    }

    private boolean execute(String sql) {
        return call(st -> st.execute(sql));
    }

    private Integer executeUpdate(String sql) {
        return call(st -> st.executeUpdate(sql));
    }

    private ResultSet executeQuery(String sql) {
        return call(st -> st.executeQuery(sql));
    }

    private SQLWarning getWarnings(SqlCallable callable) {
        try (Connection conn = getConnection()) {
            Statement statement = conn.createStatement();
            callable.run(statement);
            return statement.getWarnings();
        } catch (Exception e) {
            throw new BsStepsException("Ошибка при выполнении запроса", e);
        }
    }

    private <T> T call(SqlCallable<T> callable) {
        try (Connection conn = getConnection()) {
            Statement statement = conn.createStatement();
            return callable.run(statement);
        } catch (Exception e) {
            throw new BsStepsException("Ошибка при выполнении запроса", e);
        }
    }

    public Connection getConnection() {
        try {
            return DriverManager
                    .getConnection(String.format(BsSteps.DB_URL_TEMPLATE, resolveDatabaseNumber(getContext())), LOGIN, PASS);
        } catch (SQLException e) {
            throw new BsStepsException("Не удалось подключиться к базе данных", e);
        }
    }

    private interface SqlCallable<T> {
        T run(Statement dslContext) throws Exception;
    }
}
