package ru.yandex.autotests.direct.bsapi;

import java.io.File;
import java.util.Arrays;

import ru.yandex.autotests.direct.bsapi.models.Creative;
import ru.yandex.autotests.direct.utils.BaseSteps;
import ru.yandex.qatools.allure.annotations.Step;

/*
* todo javadoc
*/
public class BsSteps {

    public static final String REST_API_URL_TEMPLATE = "https://bsapi-test-%s.mediaselling.yandex.net/rest/v0.2/";
    public static final String DB_URL_TEMPLATE =
            "jdbc:sqlserver://display-win-sas-c32m32d300-0%s.sas.yp-c.yandex.net:2433;databaseName=BannerStorage";


    private String dbSchema;
    private String oauthToken = "AQAAAADuojedAAAKb-_Es7ZWfUZFpbYSkmKVARI";
    private ApiClient apiClient;

    /**
     * @param dbSchema ключ стенда БС (ts/ts2/devtest/dev7/load)
     */
    public BsSteps(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    public BsSteps withOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
        return this;
    }

    public ApiClient getApiClient() {
        if (apiClient == null) {
            apiClient = new ApiClient(String.format(BsSteps.REST_API_URL_TEMPLATE, resolveContext(dbSchema)));
            bsDbSteps().setAuth();
        }
        return apiClient.withAuthToken(oauthToken);
    }

    static String resolveContext(String context) {
        if (Arrays.asList("ts", "ts2").contains(context)) {
            return "pine";
        } else {
            return "maple";
        }
    }

    static String resolveDatabaseNumber(String context) {
        if (Arrays.asList("ts", "ts2").contains(context)) {
            return "1";
        } else {
            return "2";
        }
    }

    public BsDbSteps bsDbSteps() {
        return BaseSteps.getInstance(BsDbSteps.class, dbSchema);
    }

    public CreativesSteps creativesSteps() {
        return BaseSteps.getInstance(CreativesSteps.class, getApiClient());
    }

    @Step("BS: Создаем дефолтный креатив со статусом модерации {0}")
    public Integer createCreative(Templates templates, String name, String href, File logoFile,
            BsDbSteps.StatusModerate statusModerate)
    {
        Integer creativeId = createCreative(templates, name, href, logoFile);
        bsDbSteps().setCreativeStatusModerate(creativeId, statusModerate);
        return creativeId;
    }

    @Step("Увеличиваем начальный инкремент таблицы с креативами на 100 от {0}")
    public void increaseIncrement(Long lastCreativeId) {
        bsDbSteps().increaseTCreativeIncrement(lastCreativeId.intValue());
    }

    @Step("BS: Создаем креатив по шаблону {0} с именем {1}")
    public Integer createCreative(Templates templates, String name, String href, File logoFile) {
        return creativesSteps().createCreative(templates, name, href, logoFile);
    }

    @Step("BS: Создаем группу креативов с именем {1}")
    public CreativeGroupResponse createCreativeGroup(String name, Creative... creatives) {
        return creativesSteps().createCreativeGroup(name, creatives);
    }

    @Step("BS: Создаем группу креативов с именем {1}")
    public Creative prepareCreative(Templates templates, String name, String href, File logoFile) {
        return creativesSteps().prepareCreative(templates, name, href, logoFile);
    }
}
