package ru.yandex.autotests.direct.bsapi;

import com.google.gson.Gson;

import java.util.List;

public class CreativeGroupResponse {

    private Long creativeGroupId;

    private List<Long> creativeIds;

    public Long getCreativeGroupId() {
        return creativeGroupId;
    }

    public CreativeGroupResponse withCreativeGroupId(Long creativeGroupId) {
        this.creativeGroupId = creativeGroupId;
        return this;
    }

    public List<Long> getCreativeIds() {
        return creativeIds;
    }

    public CreativeGroupResponse withCreativeIds(List<Long> creativeIds) {
        this.creativeIds = creativeIds;
        return this;
    }

    public Long getFirstCreativeId() {
        return creativeIds.get(0);
    }

    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
