package ru.yandex.autotests.direct.bsapi;

import okhttp3.MediaType;
import okhttp3.RequestBody;

import ru.yandex.autotests.direct.bsapi.models.*;
import ru.yandex.autotests.direct.utils.BaseSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.io.File;
import java.io.IOException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.toList;
import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/*
* todo javadoc
*/
public class CreativesSteps extends BaseSteps<ApiClient> {

    @Step("Создаем кератив в BS")
    public Integer createCreative(Templates templates, String name, String href, File logoFile) {
        CreativesApi api = getContext().createService(CreativesApi.class);

        Creative creative = prepareCreative(templates, name, href, logoFile);

        Creative createdCreative;
        try {
            createdCreative = api.creativeCreate(creative, Collections.emptyList()).execute().body();
        } catch (IOException e) {
            throw new BsStepsException("Не удалось создать креатив", e);
        }
        System.out.println(createdCreative.toString());

        TnsBrand brand = new TnsBrand();
        brand.setId(47);

        TnsBrands brands = new TnsBrands();
        brands.setItems(Collections.singletonList(brand));

        try {
            TnsBrands actualBrands = api.setTnsBrands(createdCreative.getId(), brands).execute().body();
            assumeThat("Уснановлены Tns Brands на креатив " + createdCreative.getId(),
                    actualBrands.getItems().stream().findFirst().orElse(new TnsBrand()).getId(),
                    equalTo(brand.getId()));
        } catch (IOException e) {
            throw new BsStepsException("Не удалось установить Tns Brands для креатива " + createdCreative.getId(), e);
        }

        TnsArticle article = new TnsArticle();
        article.setId(211);

        TnsArticles articles = new TnsArticles();
        articles.setItems(Collections.singletonList(article));

        try {
            TnsArticles actualArticles = api.setTnsArticles(createdCreative.getId(), articles).execute().body();
            assumeThat("Уснановлены Tns Brands на креатив " + createdCreative.getId(),
                    actualArticles.getItems().stream().findFirst().orElse(new TnsArticle()).getId(),
                    equalTo(article.getId()));
        } catch (IOException e) {
            throw new BsStepsException("Не удалось установить Tns Articles для креатива " + createdCreative.getId(), e);
        }

        return createdCreative.getId();
    }

    @Step("Создаем креатив в BS")
    public CreativeGroupResponse createCreativeGroup(String groupName, Creative... creatives) {
        CreativeGroupsApi api = getContext().createService(CreativeGroupsApi.class);

        CreativeGroup creativeGroup = new CreativeGroup();
        creativeGroup.setName(groupName);
        creativeGroup.setCreatives(Arrays.asList(creatives));

        CreativeGroup createdGroup;
        try {
            createdGroup = api.createCreativeGroup(creativeGroup, null, false).execute().body();
        } catch (IOException e) {
            throw new BsStepsException("Не удалось создать группу креативов", e);
        }
        System.out.println(createdGroup.toString());

        List<Long> creativeIds = createdGroup.getCreatives()
                .stream()
                .map(t -> t.getId().longValue())
                .collect(Collectors.toList());

        return new CreativeGroupResponse()
                .withCreativeGroupId(createdGroup.getId().longValue())
                .withCreativeIds(creativeIds);
    }

    public Creative prepareCreative(Templates templates, String name, String href, File logoFile) {
        TemplatesApi templatesApi = getContext().createService(TemplatesApi.class);

        Template template;
        try {
            template = templatesApi.getTemplate(templates.getId(), null, Collections.singletonList("parameters"), null)
                    .execute().body();
        } catch (IOException e) {
            throw new BsStepsException("Не удалось получить шаблон " + templates.getId(), e);
        }

        Integer fileId = uploadFile(logoFile);

        List<ParameterValue> parameterValues = getDefaultValues(template.getParameters());

        ParameterValue logo = new ParameterValue();
        logo.setParamName(CreativeValues.LOGO.toString());
        logo.setValues(Collections.singletonList(fileId.toString()));

        parameterValues.add(logo);

        ParameterValue url = new ParameterValue();
        url.setParamName(CreativeValues.URL_SPECIAL_OFFER.toString());
        url.setValues(Collections.singletonList(href));

        parameterValues.add(url);

        ParameterValue text = new ParameterValue();
        text.setParamName(CreativeValues.PRIVACY_TEXT.toString());
        text.setValues(Collections.singletonList("PRIVACY_TEXT"));

        parameterValues.add(text);

        Creative creative = new Creative();
        creative.setTemplateId(templates.getId());
        creative.setParameters(parameterValues);
        creative.setName(name);
        return creative;
    }

    private List<ParameterValue> getDefaultValues(List<ParameterInfo> parameters) {
        Function<ParameterInfo, ParameterValue> mapping = p -> {
            ParameterValue value = new ParameterValue();
            value.setParamName(p.getName());
            value.setParamType(p.getTypeName());
            value.setValues(Collections.singletonList(p.getDefaultValue()));
            return value;
        };

        return parameters
                .stream()
                .filter(r -> r.getDefaultValue() != null)
                .map(mapping)
                .collect(toList());
    }

    private Integer uploadFile(File logoFile) {
        RequestBody file = RequestBody.create(MediaType.parse("multipart/form-data"), logoFile);

        FilesApi filesApi = getContext().createService(FilesApi.class);

        ru.yandex.autotests.direct.bsapi.models.File uploadedFile = null;
        try {
            uploadedFile = filesApi.uploadContentDirectly(file).execute().body();
        } catch (IOException e) {
            throw new RuntimeException("Uploading file failed", e);
        }
        return uploadedFile.getId();
    }

}
