def folderName = 'canvas'
def credentialsId = 'robot-irt-jenkins-ssh'
def canvasDevtest = 'canvas-creatives-devtest'
def canvasTS = 'canvas-creatives-ts'


folder(folderName)

job("$folderName/canvas-update-stand") {
	parameters {
        stringParam('BRANCH_NAME', 'master', 'Branch name or tag')
        stringParam('CANVAS_TAG', '', 'Build tag -- like "develop" for particular branch or "jenkins-canvas-develop-18" for particular build in the branch or "0.13.1" for particular release. Defaults to same branch as BRANCH_NAME')
        stringParam('DIRECT_INTAPI_URL', '', 'https://8999.beta1.intapi.direct.yandex.ru<br>http://api.test.direct.yandex.ru:9000')
        nodeParam('STAND') {
            description('select canvas stand to update')
            defaultNodes([canvasDevtest])
            allowedNodes([canvasDevtest, canvasTS])
            trigger('allowMultiSelectionForConcurrentBuilds')
        }
    }

    concurrentBuild()

	logRotator {
        numToKeep(10)
    }

    wrappers {
        timestamps()
        colorizeOutput()
        sshAgent('robot-irt-jenkins-ssh')
    }

	multiscm {
        git {
            remote {
                url('git@github.yandex-team.ru:MediaSelling/canvas.git')
                credentials(credentialsId)
                branch('$BRANCH_NAME')
            }
            extensions {
            	relativeTargetDirectory('canvas')
            }
        }

        git {
            remote {
                url('git@github.yandex-team.ru:direct-qa/canvas-creatives.git')
                credentials(credentialsId)
                branch('*/master')
            }
            extensions {
            	relativeTargetDirectory('direct-canvas')
            }
        }
    }

    steps {
        shell('if [ -z "$DIRECT_INTAPI_URL" ]\n' +
                'then\n' +
                '  echo "необходимо задать DIRECT_INTAPI_URL"\n' +
                '  exit 1\n' +
                'fi')
    	shell('cp direct-canvas/cert.pem canvas/nginx/cert.pem')
    	shell('cp direct-canvas/key.pem canvas/nginx/key.pem')
    	shell('cd canvas; TAG="${CANVAS_TAG:-`echo ${BRANCH_NAME}`}" CANVAS_HOST="${STAND}".qart.yandex.ru docker-compose -f docker-compose.direct-stand.yml pull')
    	shell('cd canvas; ./download_files.sh')
    	shell('cd canvas; TAG="${CANVAS_TAG:-`echo ${BRANCH_NAME}`}" CANVAS_HOST="${STAND}".qart.yandex.ru docker-compose -f docker-compose.direct-stand.yml up -d --build --remove-orphans')
    }
}
