package ru.yandex.autotests.directintapi.bstransport;

import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

/**
 * Created by pashkus on 01.09.15.
 */
public abstract class BeforeTestSingleExecutionRule extends TestWatcher {
    private static Throwable lastException;
    private static Boolean executedOnce = false;

    @Override
    protected void starting(Description description) throws Error{
        if (lastException != null)  {
            throw new Error(lastException);
        }
        if (!executedOnce){
            try{
                prepareTestData();
            }
            catch ( Throwable e) {
                lastException = e;
                throw new Error(lastException);
            }
            executedOnce = true;
        }
    }
    public abstract void prepareTestData();
}
