package ru.yandex.autotests.directintapi.bstransport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsMobileContentRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileContentRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.rules.ApiSteps;

/**
 * Created by buhter on 18/08/15.
 * Delete generated MobileContent and AdgroupsMobileContent
 * Could be simplified or removed when deleting campaign in Trashman would delete associated AdgroupsMobileContent
 */
public class MobileContentCleanupRule extends TestWatcher {
    private ApiSteps apiSteps;
    private List<Long> mobileContentIds = new ArrayList<>();
    private List<Long> pids = new ArrayList<>();
    private List<Long> mobileAppIds = new ArrayList<>();
    private int shard;
    private Long clientId;

    public MobileContentCleanupRule(ApiSteps apiSteps) {
        this.apiSteps = apiSteps;
    }

    @Override
    protected void finished(Description description) {
        DirectJooqDbSteps jooqDbSteps = apiSteps.userSteps.getDirectJooqDbSteps().useShard(shard);

        if (!mobileAppIds.isEmpty() && clientId != null) {
            for (Long mobileAppId : mobileAppIds) {
                jooqDbSteps.campaignsSteps().unsetCampaignsMobileAppId(mobileAppId, clientId);
                jooqDbSteps.mobileAppsSteps().deleteMobileAppTrackersByAppId(mobileAppId);
                jooqDbSteps.mobileAppsSteps().deleteMobileAppGoals(mobileAppId);
                jooqDbSteps.mobileAppsSteps().deleteMobileApp(mobileAppId);
            }
        }

        for (Long mobileContentId : mobileContentIds) {
            for (Long pid : pids) {
                AdgroupsMobileContentRecord adgroupsMobileContent =
                        jooqDbSteps
                                .adGroupsSteps().getAdGroupMobileContent(pid);
                if (adgroupsMobileContent != null) {
                    jooqDbSteps.adGroupsSteps()
                            .deleteAdGroupMobileContent(Collections.singleton(pid));
                }
            }
            MobileContentRecord mobileContent = jooqDbSteps
                    .mobileContentSteps().getMobileContent(mobileContentId);
            if (mobileContent != null) {
                jooqDbSteps.mobileContentSteps().deleteMobileContent(mobileContent);
            }
        }
    }

    public void setMobileContentIds(List<Long> mobileContentIds) {
        this.mobileContentIds = mobileContentIds;
    }

    public void setMobileAppIdsToDeleteAfterTest(Long clientId, List<Long> mobileAppIds) {
        this.clientId = clientId;
        this.mobileAppIds = mobileAppIds;
    }

    public void setPids(List<Long> pids) {
        this.pids = pids;
    }

    public void setShard(int shard) {
        this.shard = shard;
    }
}
