package ru.yandex.autotests.directintapi.bstransport;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.annotation.Nullable;
import javax.util.streamex.StreamEx;

import com.google.common.collect.Iterables;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListBase;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListGetItem;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleArgumentItem;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleItem;
import org.apache.commons.collections.keyvalue.DefaultKeyValue;
import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.cmd.data.banners.GroupsParameters;
import ru.yandex.autotests.direct.cmd.data.commons.group.Group;
import ru.yandex.autotests.direct.cmd.data.performanceGroups.common.CreativeBanner;
import ru.yandex.autotests.direct.cmd.rules.BannersRuleFactory;
import ru.yandex.autotests.direct.cmd.rules.PerformanceBannersRule;
import ru.yandex.autotests.direct.db.beans.ads.internal.BannersInternalTemplateVariables;
import ru.yandex.autotests.direct.db.beans.ads.internal.TemplateResourceOption;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsPerformanceStatusblgenerated;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPhoneflag;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatussitelinksmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsPerformanceNowOptimizingBy;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampOptionsStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.FeedsSource;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.FeedsUpdateStatus;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupAdditionalTargetingsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsInternalRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsPerformanceRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerAdditionalHrefsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesFormatsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerPixelsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersInternalRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsDynamicRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsRetargetingRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsInternalRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.FeedsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PerfCreativesRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.TurbolandingsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.enums.CryptaGoalsCryptaGoalType;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.enums.CryptaGoalsInterestType;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.CryptaGoalsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.TemplateResourceRecord;
import ru.yandex.autotests.direct.db.steps.BannersInternalSteps;
import ru.yandex.autotests.direct.db.steps.BidsRetargetingSteps;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.db.steps.JooqBannerImagesOpts;
import ru.yandex.autotests.direct.db.steps.PixelsSteps;
import ru.yandex.autotests.direct.httpclient.TestEnvironment;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.matchers.BeanCompareStrategy;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.web.api.models.AbstractGoalWeb;
import ru.yandex.autotests.direct.web.api.models.Condition;
import ru.yandex.autotests.direct.web.api.models.CryptaGoalWeb;
import ru.yandex.autotests.direct.web.api.models.MetrikaGoalWeb;
import ru.yandex.autotests.direct.web.api.models.RetargetingConditionWeb;
import ru.yandex.autotests.direct.web.api.steps.DirectWebApiSteps;
import ru.yandex.autotests.direct.web.api.steps.RetargetingCraftedSteps;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.darkside.model.ImageType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.BannerTemplateId;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.AdditionalTargeting;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ClientDataStdLogEntry;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ClientDataStdRequest;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Dynamic;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.GoalContext;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Resources;
import ru.yandex.autotests.directapi.darkside.model.internalads.BsTemplateVariables;
import ru.yandex.autotests.directapi.darkside.model.internalads.TargetingExpressionBuilder;
import ru.yandex.autotests.directapi.darkside.model.multipliers.BsAtom;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.Api5Bin;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Bin;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.HazelcastAnnotations;

import static java.util.Collections.emptyList;
import static java.util.Collections.singletonList;
import static java.util.function.Function.identity;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;
import static java.util.stream.Collectors.toMap;
import static org.hamcrest.CoreMatchers.nullValue;
import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.greaterThanOrEqualTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.generateImageUrl;
import static ru.yandex.autotests.directintapi.bstransport.TransportUtils.METRIKA_GOAL_UPPER_BOUND;
import static ru.yandex.autotests.directintapi.bstransport.TransportUtils.METRIKA_SEGMENT_UPPER_BOUND;
import static ru.yandex.autotests.directintapi.bstransport.TransportUtils.TRANSPORT_DATE_TIME_FORMATTER;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.passport.api.core.tools.UsefulPredicates.not;

public class TransportHelpSteps {

    private static final ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType INTERNAL_DISTRIB =
            ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType.internal_distrib;
    private static final ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType INTERNAL_AUTOBUDGET =
            ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType.internal_autobudget;
    private static final Set<ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType>
            INTERNAL_CAMPAIGN_TYPES_WITH_ROTATION_GOAL_ID = EnumSet.of(INTERNAL_DISTRIB, INTERNAL_AUTOBUDGET);
    public static final String PICTURE_BANNER_TITLE = "picture banner title";
    public static final String PICTURE_BANNER_BODY = "picture banner body";

    private ApiSteps api;
    private ImagesSteps imagesSteps;
    private DirectJooqDbSteps jooqDbSteps;
    private DirectWebApiSteps directWebApiSteps;

    public TransportHelpSteps(ApiSteps api) {
        this.api = api;
        imagesSteps = api.userSteps.imagesSteps();
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps();
    }

    public TransportHelpSteps useDbJooqSteps(DirectJooqDbSteps jooqDbSteps) {
        this.jooqDbSteps = jooqDbSteps;
        return this;
    }

    public TransportHelpSteps useDirectWebApiSteps(DirectWebApiSteps directWebApiSteps) {
        this.directWebApiSteps = directWebApiSteps;
        return this;
    }

    @Step("Получение ожидаемых в запросе транспорта данных кампании (cid = {0})")
    public Campaign buildExpectedCampaignObjFromDb(Long cid, int shard, UpdateInfo updateInfo) {
        CampaignsRecord campaigns = jooqDbSteps.useShard(shard).campaignsSteps().getCampaignById(cid);

        Campaign campaign = new Campaign();
        campaign.setUpdateInfo(updateInfo.value());
        campaign.setNdsHistory(null); //Todo: убрать инициализацию из bslogs
        campaign.setDiscountHistory(null); //Todo: убрать инициализацию из bslogs
        campaign.setEid(campaigns.getCid().toString());
        campaign.setId(campaigns.getOrderid().toString());
        return campaign;
    }

    @Step("Получение ожидаемых данных кампании внутренней рекламы в запросе транспорта (cid = {0})")
    public Campaign buildExpectedInternalCampaignObjFromDb(Long cid, int shard, UpdateInfo updateInfo) {
        Campaign campaign = new Campaign();
        campaign.setUpdateInfo(updateInfo.value());

        CampaignsRecord campaigns = jooqDbSteps.useShard(shard).campaignsSteps().getCampaignById(cid);
        campaign.setEid(campaigns.getCid().toString());
        campaign.setId(campaigns.getOrderid().toString());
        campaign.setContentType(campaigns.getType().getLiteral());
        campaign.setNdsHistory(null);
        campaign.setDiscountHistory(null);
        campaign.setSum(BigDecimal.ZERO.doubleValue());
        campaign.setSumCur(BigDecimal.ZERO.doubleValue());

        CampaignsInternalRecord campaignsInternal =
                jooqDbSteps.useShard(shard).campaignsInternalSteps().getCampaignsInternalRecord(cid);

        String serviceName =
                jooqDbSteps.useShard(shard).internalAdProductSteps().getInternalAdProductName(campaigns.getClientid());

        campaign.setServiceName(serviceName);
        campaign.setIsMobileApp(campaignsInternal.getIsMobile());
        campaign.setPageIds(campaignsInternal.getPageIds() != null ?
                StreamEx.of(campaignsInternal.getPageIds().split(",")).toList()
                : Collections.emptyList());
        campaign.setPlaceId(campaignsInternal.getPlaceId());
        if (campaignsInternal.getRfCloseByClick() != null) {
            campaign.setRfCloseByClick(campaignsInternal.getRfCloseByClick().getLiteral());
        }

        if (INTERNAL_CAMPAIGN_TYPES_WITH_ROTATION_GOAL_ID.contains(campaigns.getType())) {
            campaign.setRotationGoalId(campaignsInternal.getRotationGoalId());
        }

        if (campaigns.getType() == INTERNAL_AUTOBUDGET) {
            campaign.setSumCur(campaigns.getSum().doubleValue());
        } else {
            campaign.setRestrictionType(campaignsInternal.getRestrictionType().getLiteral());
            campaign.setRestrictionValue(campaignsInternal.getRestrictionValue());
        }

        return campaign;
    }

    @Deprecated
    public Campaign buildExpectedCampaignObjFromDb(int cid, int shard, UpdateInfo updateInfo) {
        return buildExpectedCampaignObjFromDb(Long.valueOf(cid), shard, updateInfo);
    }

    @Step("Получение ожидаемых в запросе транспорта данных группы (pid = {0})")
    public Context buildExpectedContextObjFromDb(Long pid, int shard, UpdateInfo updateInfo) {
        PhrasesRecord phrases = jooqDbSteps.useShard(shard).adGroupsSteps().getPhrases(pid);

        Context context = new Context();
        context.setUpdateInfo(updateInfo.value());
        context.setEid(phrases.getPid().toString());
        return context;
    }

    @Step("Получение ожидаемых данных группы внутренней рекламы в запросе транспорта (pid = {0})")
    public Context buildExpectedContextInternalObjFromDb(Long pid, int shard, UpdateInfo updateInfo) {
        jooqDbSteps.useShard(shard);
        Context context = new Context();
        context.setUpdateInfo(updateInfo.value());
        PhrasesRecord phrases = jooqDbSteps.adGroupsSteps().getPhrases(pid);
        context.setEid(phrases.getPid().toString());
        context.setGeo(StreamEx.of(phrases.getGeo().split(",")).toList());
        context.setType(phrases.getAdgroupType().getLiteral());

        AdgroupsInternalRecord adgroupsInternal = jooqDbSteps.adGroupsInternalSteps().getAdGroupsInternal(pid);
        context.setLevel(adgroupsInternal.getLevel());
        context.setRfDays(adgroupsInternal.getRfreset());
        context.setMaxRF(adgroupsInternal.getRf().intValue());
        context.setStartTime(adgroupsInternal.getStartTime() == null ? null
                : adgroupsInternal.getStartTime().toLocalDateTime().format(TRANSPORT_DATE_TIME_FORMATTER));
        context.setFinishTime(adgroupsInternal.getFinishTime() == null ? null
                : adgroupsInternal.getFinishTime().toLocalDateTime().format(TRANSPORT_DATE_TIME_FORMATTER));

        context.setAdditionalTargetings(buildExpectedAdditionalTargetingObjFromDb(pid, shard));
        context.setTargetingExpression(buildExpectedTargetingExpressionObjFromDb(pid, shard));
        return context;
    }

    @Step("Получение ожидаемых данных дополнительных таргетингов группы в запросе транспорта (pid = {0})")
    public Map<Long, AdditionalTargeting> buildExpectedAdditionalTargetingObjFromDb(Long pid, int shard) {
        List<AdgroupAdditionalTargetingsRecord> adGroupAdditionalTargetings =
                jooqDbSteps.useShard(shard).adGroupsInternalSteps().getAdGroupAdditionalTargetings(pid);

        return StreamEx.of(adGroupAdditionalTargetings)
                .mapToEntry(AdgroupAdditionalTargetingsRecord::getId, record -> new AdditionalTargeting()
                        .withEid(record.getId())
                        .withTargetingMode(record.getTargetingMode().getLiteral())
                        .withTargetingType(record.getTargetingType().getLiteral())
                        .withValueJoinType(record.getValueJoinType().getLiteral())
                        .withValue(record.getValue()))
                .toMap();
    }

    @Step("Получение ожидаемого значения TargetingExpression группы в запросе транспорта (pid = {0})")
    public List<List<BsAtom>> buildExpectedTargetingExpressionObjFromDb(Long pid, int shard) {
        List<AdgroupAdditionalTargetingsRecord> adGroupAdditionalTargetings =
                jooqDbSteps.useShard(shard).adGroupsInternalSteps().getAdGroupAdditionalTargetings(pid);
        if (adGroupAdditionalTargetings.isEmpty()) {
            return null;
        }
        TargetingExpressionBuilder builder = TargetingExpressionBuilder.init();
        adGroupAdditionalTargetings.forEach(builder::add);
        return builder.build();
    }

    @Step("Получение ожидаемых данных баннера в запросе транспорта (bid = {0})")
    public Banner buildExpectedBannerInternalObjFromDb(Long bid, int shard, UpdateInfo updateInfo) {
        jooqDbSteps.useShard(shard);
        Banner banner = new Banner();
        banner.setUpdateInfo(updateInfo.value());

        BannersRecord dbBanner = jooqDbSteps.bannersSteps().getBanner(bid);
        banner.setEid(dbBanner.getBid().toString());
        banner.setId(dbBanner.getBannerid().toString());

        BannersInternalRecord bannersInternal = jooqDbSteps.bannersInternalSteps().getBannersInternal(bid);
        List<BannersInternalTemplateVariables> templateVariables =
                BannersInternalSteps.getTemplateVariables(bannersInternal);

        return banner
                .withTemplateId(bannersInternal.getTemplateId().intValue())
                .withResources(new Resources()
                        .withTemplateVariables(convertToBsTemplateVariables(templateVariables)));
    }

    @Step("Получение ожидаемых данных нового баннера в запросе транспорта (bid = {0})")
    public Banner buildExpectedNewBannerInternalObjFromDb(Long bid, int shard) {
        Banner banner = buildExpectedBannerInternalObjFromDb(bid, shard, UpdateInfo.UPDATE);
        String bannerId = String.valueOf((bid & 0x00FFFFFFFFFFFFFFL) + 0x0100000000000000L);
        banner.setId(bannerId);
        banner.setStop(StopFlag.STOP.value());
        banner.setIsNewBanner(1);
        return banner;
    }

    private List<BsTemplateVariables> convertToBsTemplateVariables(
            List<BannersInternalTemplateVariables> templateVariables)
    {
        List<Long> templateResourceIds = StreamEx.of(templateVariables)
                .map(BannersInternalTemplateVariables::getTemplateResourceId)
                .toList();
        Map<Long, TemplateResourceRecord> templateResourcesByIds =
                jooqDbSteps.templateResourceSteps().getTemplateResourcesByIds(templateResourceIds);

        return StreamEx.of(templateVariables)
                .map(t -> convertToBsTemplateVariable(t, templateResourcesByIds.get(t.getTemplateResourceId())))
                .nonNull()
                .toList();
    }

    @Nullable
    private BsTemplateVariables convertToBsTemplateVariable(BannersInternalTemplateVariables templateVariable,
            TemplateResourceRecord resourceRecord)
    {
        if (templateVariable.getInternalValue() == null || resourceRecord == null) {
            return null;
        }

        BsTemplateVariables bsTemplateVariables = new BsTemplateVariables()
                .withValue(templateVariable.getInternalValue())
                .withTemplatePartNo(resourceRecord.getTemplatePartNo())
                .withTemplateResourceId(resourceRecord.getId())
                .withTemplateResourceNo(resourceRecord.getResourceNo());

        if (resourceRecord.getOptions().contains(TemplateResourceOption.BANANA_IMAGE.getTypedValue())) {
            BannerImagesFormatsRecord formatsRecord =
                    jooqDbSteps.imagesSteps().getBannerImagesFormatsRecords(templateVariable.getInternalValue());
            if (formatsRecord == null) {
                return null;
            }

            bsTemplateVariables
                    .withHeight(formatsRecord.getHeight().intValue())
                    .withWidth(formatsRecord.getWidth().intValue())
                    .withValue(generateImageUrl(formatsRecord));
        }

        return bsTemplateVariables;
    }

    @Step("Получение ожидаемых в запросе транспорта данных фразы (bidsId = {0})")
    public Phrase buildExpectedPhraseObjFromDb(long bidsId, int shard, UpdateInfo updateInfo) {
        BidsRecord bids = jooqDbSteps.useShard(shard).bidsSteps().getBidById(bidsId);

        Phrase phrase = new Phrase();
        phrase.setUpdateInfo(updateInfo.value());
        phrase.setEid(bids.getId().toString());
        phrase.setId(bids.getPhraseid().toString());
        return phrase;
    }

    @Step("Получение ожидаемых в запросе транспорта данных баннера (bid = {0})")
    public Banner buildExpectedBannerObjFromDb(Long bid, int shard, UpdateInfo updateInfo) {
        BannersRecord dbBanner = jooqDbSteps.useShard(shard).bannersSteps().getBanner(bid);

        Banner banner = new Banner();
        banner.setUpdateInfo(updateInfo.value());
        banner.setEid(dbBanner.getBid().toString());
        banner.setId(dbBanner.getBannerid().toString());
        return banner;
    }

    @Step("Получение ожидаемых в запросе транспорта данных нового баннера (bid = {0})")
    public Banner buildExpectedNewBannerObjFromDb(Long bid, int shard, UpdateInfo updateInfo) {
        Banner banner = buildExpectedBannerObjFromDb(bid, shard, updateInfo);
        String bannerId = calculateBannerId(bid);
        banner.setId(bannerId);
        banner.setStop(StopFlag.STOP.value());
        banner.setIsNewBanner(1);
        return banner;
    }

    @Step("Получаем ожидания для основных полей баннера (bid = {0}")
    public Banner buildExpectedCommonBannerFromDb(Long bid) {
        BannersRecord bannerRec = jooqDbSteps.bannersSteps().getBanner(bid);

        Banner banner = new Banner();
        banner.setEid(bannerRec.getBid().toString());
        //banner.setId(bannerRec.getBannerid().toString());
        banner.setId("0");
        banner.setDynamic(0);
        banner.setPriorityId("0");
        //banner.setAge("");  //
        //banner.setHref(bannerRec.getHref());
        //banner.setFlags((bannerRec.getFlags() == null || bannerRec.getFlags().isEmpty())?"":bannerRec.getFlags());
        //age:18 -> plus18
        banner.setTitle(bannerRec.getTitle());
        banner.setBody(bannerRec.getBody());
        banner.setArchive(0);
        banner.setGeoFlag("0");
        //banner.setMarketRating(-1);   //Todo: разница на РМП: marketRating: null but expected -1 - починить предсказания
        banner.setMobile(bannerRec.getType().equals(BannersType.mobile) ? 1 : 0);
        banner.setLang("ru");
        banner.setUpdateInfo(UpdateInfo.UPDATE.value());
        //banner.setSite("");           //Todo: getSite() from banners.href
        //banner.setDomainFilter(bannerRec.getDomain());  //Todo:
        //banner.setHideDomain("0");      //Todo: get it from banners.opts
        //banner.setSiteFilter(bannerRec.getDomain());
        return banner;
    }

    @Step("Получаем ожидания для основных полей баннера (bid = {0}")
    public Banner buildExpectedNewCommonBannerFromDb(Long bid) {
        Banner banner = buildExpectedCommonBannerFromDb(bid);
        String bannerId = calculateBannerId(bid);
        banner.setId(bannerId);
        banner.setStop(StopFlag.STOP.value());
        banner.setIsNewBanner(1);
        return banner;
    }

    @Step("Получаем ожидания для графического баннера (bid = {0})")
    public Banner buildExpectedImageBannerFromDb(Long bid) {

        Banner banner = buildExpectedCommonBannerFromDb(bid);
        banner.setIsMediaImage(1);  //флаг устанавливается при наличии связи с banner_images
        banner.setTemplateId(BannerTemplateId.MEDIA_IMAGE_TEMPLATE_ID.value());
        banner.setBody(null);       //Не проверяем.  Todo = "alt" + images.image_hash
        banner.setTitle(null);      //Не проверяем.
        //banner.setMediaImage( getExpectedMediaImage(bid));
        return banner;
    }

    @Step("Получаем ожидания для нового графического баннера (bid = {0})")
    public Banner buildExpectedNewImageBannerFromDb(Long bid) {

        Banner banner = buildExpectedImageBannerFromDb(bid);
        String bannerId = calculateBannerId(bid);
        banner.setId(bannerId);
        banner.setStop(StopFlag.STOP.value());
        banner.setIsNewBanner(1);
        return banner;
    }

    @Step("Получаем ожидания для креативного баннера (bid = {0})")
    public Banner buildExpectedCanvasBannerFromDb(Long bid) {
        Banner banner = buildExpectedCommonBannerFromDb(bid);
        //изменения по сравнению с ТГО
        //banner.setSite("")    // todo: берем из разных мест в зависимости от типа баннера
        banner.setTitle(""); //fill up according to banners_performance.extracted_text (33 symbols)
        banner.setBody("");  //fill up with tail remaining from
        banner.setStop(1);
        banner.setIsMediaCreative(1); //флаг устанавливается при наличии связи с banners_performance;
        banner.setResources(buildExpectedBannerResourcesFromDb(bid));
        banner.setCreative(jooqDbSteps.bannersPerformanceSteps().findCreativeIds(bid));
        banner.setTemplateId(BannerTemplateId.MEDIA_CREATIVE_TEMPLATE_ID.value());
        return banner;
    }

    @Step("Получаем ожидания для нового креативного баннера (bid = {0})")
    public Banner buildExpectedNewCanvasBannerFromDb(Long bid) {
        Banner banner = buildExpectedCanvasBannerFromDb(bid);
        String bannerId = calculateBannerId(bid);
        banner.setId(bannerId);
        banner.setStop(StopFlag.STOP.value());
        banner.setIsNewBanner(1);
        return banner;
    }

    @Step("Получаем ожидания для cpm_outdoor баннера (bid = {0})")
    public Banner buildExpectedCpmOutdoorBannerFromDb(Long bid) {

        Banner banner = buildExpectedCommonBannerFromDb(bid);
        banner.setIsVideoCreativeOutdoor(1);  //флаг устанавливается при наличии связи с banner_images
        banner.setBody(PICTURE_BANNER_BODY);       //Фейковый
        banner.setTitle(PICTURE_BANNER_TITLE);     //Фейковый
        banner.setHref("http://ya.ru");
        banner.setLang(null);
        banner.setResources(new Resources().withAutoVideoCreative(
                Iterables.getFirst(jooqDbSteps.bannersPerformanceSteps().findCreativeIds(bid), null)));
        return banner;
    }

    @Step("Получаем ожидания для нового cpm_outdoor баннера (bid = {0})")
    public Banner buildExpectedNewCpmOutdoorBannerFromDb(Long bid) {
        Banner banner = buildExpectedCpmOutdoorBannerFromDb(bid);
        String bannerId = calculateBannerId(bid);
        banner.setId(bannerId);
        banner.setStop(StopFlag.STOP.value());
        banner.setIsNewBanner(1);
        return banner;
    }

    @Step("Получаем ожидания для cpm_indoor баннера (bid = {0})")
    public Banner buildExpectedCpmIndoorBannerFromDb(Long bid) {

        Banner banner = buildExpectedCommonBannerFromDb(bid);
        banner.setIsVideoCreativeIndoor(1);  //флаг устанавливается при наличии связи с banner_images
        banner.setBody(PICTURE_BANNER_BODY);       //Фейковый
        banner.setTitle(PICTURE_BANNER_TITLE);      //Фейковый
        banner.setHref("http://ya.ru");
        banner.setLang(null);
        banner.setResources(new Resources().withAutoVideoCreative(
                Iterables.getFirst(jooqDbSteps.bannersPerformanceSteps().findCreativeIds(bid), null)));
        return banner;
    }

    @Step("Получаем ожидания для нового cpm_indoor баннера (bid = {0})")
    public Banner buildExpectedNewCpmIndoorBannerFromDb(Long bid) {

        Banner banner = buildExpectedCpmIndoorBannerFromDb(bid);
        String bannerId = calculateBannerId(bid);
        banner.setId(bannerId);
        banner.setStop(StopFlag.STOP.value());
        banner.setIsNewBanner(1);
        return banner;
    }

    @Step("Получаем ожидания для cpm_audio баннера (bid = {0})")
    public Banner buildExpectedCpmAudioBannerFromDb(Long bid) {
        Banner banner = buildExpectedCommonBannerFromDb(bid);
        banner.setIsAudioCreative(1);
        banner.setHref("http://ya.ru");
        banner.setLang(null);
        banner.setResources(new Resources().withAutoVideoCreative(
                Iterables.getFirst(jooqDbSteps.bannersPerformanceSteps().findCreativeIds(bid), null)));
        List<String> viewNoticeHrefs =
                jooqDbSteps.pixelsSteps().getBannerPixelsByBid(bid)
                        .stream()
                        .map(BannerPixelsRecord::getPixelUrl)
                        .map(PixelsSteps::replaceRandomMacrosForBS)
                        .collect(Collectors.toList());
        if (!viewNoticeHrefs.isEmpty()) {
            banner.setViewNoticeHrefs(viewNoticeHrefs);
        }
        return banner;
    }

    @Step("Получаем ожидания для нового cpm_audio баннера (bid = {0})")
    public Banner buildExpectedNewCpmAudioBannerFromDb(Long bid) {
        Banner banner = buildExpectedCpmAudioBannerFromDb(bid);
        String bannerId = calculateBannerId(bid);
        banner.setId(bannerId);
        banner.setStop(StopFlag.STOP.value());
        banner.setIsNewBanner(1);
        return banner;
    }

    @Step("Получаем ожидания для баннера с html5-креативом (bid = {0})")
    public Banner buildExpectedHTML5CreativeBannerFromDb(Long bid) {
        Banner banner = buildExpectedCommonBannerFromDb(bid);
        banner.setTitle("");
        banner.setBody("");
        banner.setStop(1);
        banner.setIsMediaCreative(1);
        banner.setResources(buildExpectedHTML5CreativeBannerResourcesFromDb(bid));
        banner.setCreative(jooqDbSteps.bannersPerformanceSteps().findCreativeIds(bid));
        banner.setTemplateId(BannerTemplateId.HTML5_CREATIVE_TEMPLATE_ID.value());
        return banner;
    }

    @Step("Получаем ожидания для cpm-баннера с видео-креативом (bid = {0})")
    public Banner buildExpectedCpmVideoBannerFromDb(Long bid) {
        Banner banner = buildExpectedCommonBannerFromDb(bid);
        String bannerId = calculateBannerId(bid);
        banner.setId(bannerId);
        banner.setTitle(PICTURE_BANNER_TITLE);   //фейковый
        banner.setBody(PICTURE_BANNER_BODY);     //фейковый
        banner.setIsFakeTitle(1);
        banner.setIsFakeBody(1);
        banner.setStop(1);
        banner.setIsVideoCreative(1);
        banner.setLang(null);
        banner.setCreative(null);
        Long creativeId = jooqDbSteps.bannersPerformanceSteps().findCreativeIds(bid).get(0);
        banner.setResources(new Resources().withAutoVideoCreative(creativeId));
        return banner;
    }

    @Step("Получаем ожидания для нового баннера с html5-креативом (bid = {0})")
    public Banner buildExpectedNewHTML5CreativeBannerFromDb(Long bid) {
        Banner banner = buildExpectedHTML5CreativeBannerFromDb(bid);
        String bannerId = calculateBannerId(bid);
        banner.setId(bannerId);
        banner.setStop(StopFlag.STOP.value());
        banner.setIsNewBanner(1);
        return banner;
    }


    @Step("Получение ожидаемых данных для поля MediaImage")
    public String[] getExpectedMediaImage(BannerImagesFormatsRecord bannerImagesFormatsRecord) {
        String mdsUrl = new StringBuilder().append("//")
                .append(bannerImagesFormatsRecord.getAvatarsHost().getLiteral())
                .append("/get-")
                .append(bannerImagesFormatsRecord.getNamespace().getLiteral())
                .append("/")
                .append(bannerImagesFormatsRecord.getMdsGroupId()).append("/")
                .append(bannerImagesFormatsRecord.getImageHash())
                .append("/orig")
                .toString();

        return
                new String[]{
                        mdsUrl,
                        String.valueOf(bannerImagesFormatsRecord.getWidth() / 2),
                        String.valueOf(bannerImagesFormatsRecord.getHeight() / 2)
                };
    }

    public Resources buildExpectedBannerResourcesFromDb(Long bid) {
        Resources resources = new Resources();
        BannersRecord bannerRec = jooqDbSteps.bannersSteps().getBanner(bid);
        resources.setTitle("");
        resources.setBody("");
        //resources.setUrl(bannerRec.getHref());   //todo: заполняется в зависимости от типа баннера. ask @ppalex
        resources.setDomain(bannerRec.getDomain());
        resources.setCreative(jooqDbSteps.bannersPerformanceSteps().findCreativeIds(bid));
        return resources;
    }

    public Resources buildExpectedHTML5CreativeBannerResourcesFromDb(Long bid) {
        BannersRecord bannerRec = jooqDbSteps.bannersSteps().getBanner(bid);
        List<Long> creativeIds = jooqDbSteps.bannersPerformanceSteps().findCreativeIds(bid);
        PerfCreativesRecord perfCreativesRecord = jooqDbSteps.perfCreativesSteps().getPerfCreatives(creativeIds.get(0));
        TurbolandingsRecord bannerTurbolandings = jooqDbSteps.bannerTurbolandingsSteps().getBannerTurbolandingData(bid);
        Resources resources = new Resources()
                .withCreative(creativeIds)
                .withCreativeHref1(bannerRec.getHref())
                .withCreativeTurboLandingHref1(bannerTurbolandings == null ? null : bannerTurbolandings.getHref())
                .withRenderInfo(perfCreativesRecord.getYabsData());
        // Заполняем дополнительные ссылки на баннеры
        List<BannerAdditionalHrefsRecord> bannerAdditionalHrefs
                = jooqDbSteps.bannerAdditionalHrefSteps().getBannerAdditionalHrefsData(bid);
        if (bannerAdditionalHrefs.size() > 0)
            resources.setCreativeHref2(bannerAdditionalHrefs.get(0).getHref());
        // Если только одна ссылка - вторую не заполняем
        if (bannerAdditionalHrefs.size() > 1)
            resources.setCreativeHref3(bannerAdditionalHrefs.get(1).getHref());

        if (perfCreativesRecord.getSourceMediaType() != null) {
            resources.setCreativeComposedFrom(perfCreativesRecord.getSourceMediaType().getLiteral());
        }

        return resources;
    }

    public String[] getExpectedMediaImage(String imageHash) {
        return getExpectedMediaImage(jooqDbSteps.imagesSteps().getBannerImagesFormatsRecords(imageHash));
    }

    public String[] getExpectedMediaImage(Long cid, Long pid, Long bid) {
        String imageHash = jooqDbSteps.imagesSteps().getImagesRecords(cid, pid, bid).getImageHash();
        return getExpectedMediaImage(jooqDbSteps.imagesSteps().getBannerImagesFormatsRecords(imageHash));
    }

    @Step("Получение ожидаемых в запросе транспорта данных ретаргетинга (ret_id = {0})")
    public GoalContext buildExpectedRetargetingObjFromDb(Long retId, int shard, UpdateInfo updateInfo) {
        BidsRetargetingSteps retSteps = jooqDbSteps.useShard(shard).bidsRetargetingSteps();
        BidsRetargetingRecord bidsRetargeting = retSteps.getBidsRetargeting(retId);

        GoalContext goalContext = new GoalContext();
        goalContext.setUpdateInfo(updateInfo.value());
        goalContext.setId("" + bidsRetargeting.getRetCondId());
        goalContext.setEid("" + bidsRetargeting.getRetId());

        return goalContext;
    }

    @Step("Получение ожидаемых в запросе транспорта данных ретаргетинга (ret_id = {0},  ret_cond_id = {1})")
    public GoalContext buildExpectedRetargetingObjFromDb(Long retId, Long retCondId, int shard, UpdateInfo updateInfo) {
        GoalContext goalContext = buildExpectedRetargetingObjFromDb(retId, shard, updateInfo);
        goalContext.setExpression(getRetConditionsBSStyle(retCondId));
        return goalContext;
    }

    @Step("Получение ожидаемых в запросе транспорта данных картиночного баннера (imageId = {0})")
    public Banner buildExpectedPicBannerObjFromDb(Long imageId, int shard, UpdateInfo updateInfo) {
        BannerImagesRecord bannerImagesRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).imagesSteps().getBannerImages(imageId);

        Banner banner = new Banner();
        banner.setUpdateInfo(updateInfo.value());
        banner.setEid("" + bannerImagesRecord.getImageId());
        banner.setId("" + bannerImagesRecord.getBannerid());
        banner.setParentExportId("" + bannerImagesRecord.getBid());

        return banner;
    }

    @Step("Получение ожидаемых в запросе транспорта данных картиночного баннера (imageId = {0})," +
            " для единого баннера отправки")
    public Banner buildExpectedPicBannerObjFromDbForSingleSend(Long parentBid, UpdateInfo updateInfo) {
        String bannerId = calculateBannerId(parentBid);

        Banner banner = new Banner();
        banner.setUpdateInfo(updateInfo.value());
        banner.setEid(parentBid.toString());
        banner.setId(bannerId);
        banner.setParentExportId(null);
        return banner;
    }

    @Step("Формирование матчера для картиночного баннера в запросе транспорта (imageId = {0})")
    public Matcher<Banner> buildPicBannerMatcherFromDb(Long imageId,
            int shard,
            UpdateInfo updateInfo)
    {
        Banner banner = buildExpectedPicBannerObjFromDb(imageId, shard, updateInfo);
        banner.setStop(0);
        return buildPicBannerMatcher(banner);
    }

    @Step("Формирование матчера для нового картиночного баннера в запросе транспорта (imageId = {0})")
    public Matcher<Banner> buildNewPicBannerMatcherFromDbWithBannerId(Long imageId,
                                                                      int shard,
                                                                      UpdateInfo updateInfo) {
        Banner banner = buildExpectedPicBannerObjFromDb(imageId, shard, updateInfo);
        return buildNewPicBannerMatcherFromDb(banner, imageId);
    }

    @Step("Формирование матчера для нового картиночного баннера в запросе транспорта (imageId = {0}) " +
            "для единого баннера отправки")
    public Matcher<Banner> buildNewPicBannerMatcherFromDbForSingleSend(Long imageId,
                                                                       Long parentBid,
                                                                       int shard,
                                                                       UpdateInfo updateInfo) {
        Banner banner = buildExpectedPicBannerObjFromDb(imageId, shard, updateInfo);
        banner.setParentExportId(null);
        return buildNewPicBannerMatcherFromDb(banner, parentBid);
    }

    public Matcher<Banner> buildNewPicBannerMatcherFromDb(Banner banner, Long bid) {
        String bannerId = calculateBannerId(bid);
        banner.setId(bannerId);
        banner.setEid(bid.toString());
        banner.setStop(1);
        banner.setIsNewBanner(1);
        return buildPicBannerMatcher(banner);
    }

    public BeanEquals<Campaign> campaignReq1Matcher(Long cid, int shard) {
        return campaignReq1Matcher(cid, shard, true);
    }

    @Step("Формирование матчера для кампании в первом запросе транспорта, с проверкой значения Stop ? {2}")
    public BeanEquals<Campaign> campaignReq1Matcher(Long cid, int shard, boolean withStop) {

        Campaign expectedCampaign = buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.UPDATE);

        if (withStop) {
            expectedCampaign.setStop(StopFlag.STOP.value());
        }

        return campaignReq1Matcher(expectedCampaign);
    }

    public BeanEquals<Campaign> campaignReq1Matcher(Campaign expectedCampaign) {
        expectedCampaign.setId(null);
        return BeanEquals.beanEquals(expectedCampaign).accordingStrategy(
                new BeanCompareStrategy().putFieldMatcher("Id", greaterThan("0"))
        );
    }

    @Step("Загрузка картинок пользователю {0}, типа {1}, если картинки отсутствуют")
    @HazelcastAnnotations.Lock("tests.direct.bs.transport.images.add")
    public String[] addImagesForUserIfNotExists(String login, ImageType type) {
        String[] hashes = imagesSteps.getAccountImageHashes(login);
        int imgAmount;
        switch (type) {
            case REGULAR:
                //большая картинка вызывает OOM в Акве
                imgAmount =
                        3;//ImagesSteps.validRegularImages.size() <= 10 ? ImagesSteps.validRegularImages.size() : 10;
                if (hashes == null || hashes.length < imgAmount) {
                    int[] nums = new int[imgAmount];
                    for (int i = 1; i <= imgAmount; i++) {
                        nums[i - 1] = i;
                    }
                    hashes = imagesSteps
                            .configLoginImages(login, ru.yandex.autotests.directapi.enums.ImageType.REGULAR, nums);
                    for (String hash : hashes) {
                        assumeThat("картинка успешно загрузилась", hash, notNullValue());
                        removeObjectsFromBin(imagesSteps.bin, hash);
                    }
                }
                break;
            case WIDE:
                //Самая большая картинка вызывает OOM в Акве
                imgAmount = 2;//ImagesSteps.validWideImages.size() <= 10 ? ImagesSteps.validWideImages.size() : 10;
                if (hashes == null || hashes.length < imgAmount) {
                    int[] nums = new int[imgAmount];
                    for (int i = 1; i <= imgAmount; i++) {
                        nums[i - 1] = i;
                    }
                    hashes = imagesSteps
                            .configLoginImages(login, ru.yandex.autotests.directapi.enums.ImageType.WIDE, nums);
                    for (String hash : hashes) {
                        assumeThat("картинка успешно загрузилась", hash, notNullValue());
                        removeObjectsFromBin(imagesSteps.bin, hash);
                    }
                }
                break;
            default:
                throw new RuntimeException("Попытка добавить картинки неизвестного происхождения");
        }

        return hashes;
    }

    @Step("Добавление условий ретаргетинга пользователю {0}, если отсутствуют")
    @HazelcastAnnotations.Lock("tests.direct.bs.transport.retargetings.add")
    public List<Long> addRetargetingListsForUserIfNotExists(String login) {

        final int RETARGETING_NUM = 6;

        List<RetargetingListGetItem> retargetingLists =
                api.userSteps.retargetingListsSteps().getRetargetingByLogin(login);

        if (retargetingLists.size() < RETARGETING_NUM) {

            List<Long> existingGoalIds = retargetingLists.stream()
                    .map(RetargetingListBase::getRules)
                    .flatMap(Collection::stream)
                    .map(RetargetingListRuleItem::getArguments)
                    .flatMap(Collection::stream)
                    .map(RetargetingListRuleArgumentItem::getExternalId)
                    .collect(Collectors.toList());

            List<Long> goalIds = api.userSteps.retargetingSteps()
                    .getRetargetingGoalIDsByType(login, RetargetingGoalType.GOAL)
                    .stream()
                    .filter(not(existingGoalIds::contains))
                    .collect(Collectors.toList());

            assumeThat("целей у логина достаточно", goalIds,
                    hasSize(greaterThanOrEqualTo(RETARGETING_NUM - retargetingLists.size())));

            Collections.shuffle(goalIds);
            List<RetargetingListAddItemMap> retargetingListAddItemMaps = new ArrayList<>();
            for (int i = 0; i < RETARGETING_NUM; i++) {
                Long goalId = goalIds.get(i);
                retargetingListAddItemMaps.add(new RetargetingListAddItemMap()
                        .defaultRetargetingListAddItemMap(new RetargetingListRuleArgumentItemMap()
                                .withDefaultMembershipLifeSpan()
                                .withExternalId(goalId)));
            }

            List<Long> retargetingListsIds = api.userSteps.retargetingListsSteps().add(login, new AddRequestMap()
                    .withRetargetingLists(retargetingListAddItemMaps.toArray(new RetargetingListAddItemMap[0])));
            for (Long retCondId : retargetingListsIds) {
                removeObjectsFromApi5Bin(api.userSteps.retargetingListsSteps().bin, retCondId);
            }
            return retargetingListsIds;
        } else {
            return retargetingLists.stream()
                    .map(RetargetingListGetItem::getId)
                    .collect(Collectors.toList());
        }
    }

    /**
     * Убрать из условий ретаргетинга те, в которых есть сегменты
     */
    public List<Long> filterConditionsWithSegments(List<Long> retCondIds) {
        return api.userSteps.retargetingListsSteps()
                .get(retCondIds)
                .stream()
                .filter(not(TransportHelpSteps::hasSegment))
                .map(RetargetingListGetItem::getId)
                .collect(Collectors.toList());
    }

    private static boolean hasSegment(RetargetingListGetItem ret) {
        for (RetargetingListRuleItem rule : ret.getRules()) {
            for (RetargetingListRuleArgumentItem arg : rule.getArguments()) {
                long goalId = arg.getExternalId();
                if (goalId > METRIKA_GOAL_UPPER_BOUND && goalId <= METRIKA_SEGMENT_UPPER_BOUND) {
                    return true;
                }
            }
        }
        return false;
    }

    private void removeObjectsFromBin(Bin<DefaultKeyValue> bin, Object value) {
        Set<DefaultKeyValue> set = bin.getBin();
        for (DefaultKeyValue keyValue : new HashSet<>(set)) {
            if (value.equals(keyValue.getValue())) {
                bin.removeFromBin(keyValue);
            }
        }
    }

    private void removeObjectsFromApi5Bin(Api5Bin<Long> bin, Long value) {
        Map<Long, String> map = bin.getBin();
        map.remove(value);
    }

    private Matcher<Banner> buildPicBannerMatcher(Banner banner) {
        BeanCompareStrategy strategy = new BeanCompareStrategy();
        strategy.putFieldMatcher("picture", nullValue());
        strategy.putFieldMatcher("pictureMD5", nullValue());
        return BeanEquals.beanEquals(banner).accordingStrategy(strategy);
    }

    @Step("Получаем сырые данные по кампании {1} из логов")
    public Map<String, Map> getOrderMap(RunBsTransportScriptResponse resp, Long cid) {
        Map<String, Map> logs =
                api.userSteps.getDarkSideSteps().getTransportSteps().getRawClientDataLogEntriesForCampaign(resp, cid);
        Map<String, Map> logEntryReq1 = logs.get(resp.getUuid()[0]);
        Map<String, Map> requestReq1 = logEntryReq1 != null ?
                logEntryReq1.get(ClientDataStdLogEntry.REQUEST) : null;
        Map<String, Map> ordersReq1 = requestReq1 != null ?
                requestReq1.get(ClientDataStdRequest.ORDERS) : null;
        return ordersReq1 != null ? ordersReq1.get(String.valueOf(cid)) : null;
    }

    @Step("Получаем сырые данные по группе {2} кампании {1} из логов")
    public Map<String, Map> getContextMap(RunBsTransportScriptResponse resp, Long cid, Long pid) {
        Map<String, Map> logs =
                api.userSteps.getDarkSideSteps().getTransportSteps().getRawClientDataLogEntriesForCampaign(resp, cid);
        Map<String, Map> logEntryReq1 = logs.get(resp.getUuid()[0]);
        Map<String, Map> requestReq1 = logEntryReq1 != null ?
                logEntryReq1.get(ClientDataStdLogEntry.REQUEST) : null;
        Map<String, Map> ordersReq1 = requestReq1 != null ?
                requestReq1.get(ClientDataStdRequest.ORDERS) : null;
        Map<String, Map> orderReq1 = ordersReq1 != null ?
                ordersReq1.get(String.valueOf(cid)) : null;
        Map<String, Map> contextsReq1 = orderReq1 != null ?
                orderReq1.get(Campaign.CONTEXTS) : null;
        return contextsReq1 != null ?
                contextsReq1.get(String.valueOf(pid)) : null;
    }

    @Step("Получаем сырые данные по группе {2} кампании {1} из логов")
    public Map<String, Map> getBannerMap(RunBsTransportScriptResponse resp, Long cid, Long pid, Long bid) {
        Map<String, Map> contextsReq = getContextMap(resp, cid, pid);
        Map<String, Map> bannerReq = contextsReq != null ? contextsReq.get(Context.BANNERS) : null;
        return bannerReq != null ? bannerReq.get(String.valueOf(bid)) : null;
    }

    public Long addAndAcceptPerformanceGroupWithBanner(String login, Long cid, int shard) {
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        int goalId = MetrikaGoals.getRandom();
        jooqDbSteps.campaignsSteps().addCampMetrikaGoals(cid, (long) goalId, 10L, 100L);

        api.userSteps.campaignSteps()
                .campaignsUpdate(new ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(cid)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withBiddingStrategy(new TextCampaignStrategyMap()
                                                .withNetwork(new TextCampaignNetworkStrategyMap()
                                                        .defaultAverageRoi((long) goalId))
                                                .withSearch(new TextCampaignSearchStrategyMap().defaultServingOff()))))
                );

        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);

        PhrasesRecord phrasesRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().getPhrases(pid);
        phrasesRecord.setAdgroupType(PhrasesAdgroupType.performance);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().updatePhrases(phrasesRecord);
        BannersRecord bannersRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(bid);
        bannersRecord.setBannerType(BannersBannerType.performance);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().updateBanners(bannersRecord);

        api.userSteps.campaignFakeSteps().setType(cid, CampaignsType.PERFORMANCE);
        CampaignsRecord campaignsRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cid);
        campaignsRecord.getStrategyData().getAsJsonObject().addProperty("filter_avg_bid", 5.01D);
        campaignsRecord.setStrategyData(campaignsRecord.getStrategyData());
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().updateCampaigns(campaignsRecord);

        FeedsRecord feeds = new FeedsRecord();
        feeds.setClientid(Long.valueOf(User.get(login).getClientID()));
//        feeds.setFeedType(FeedsFeedType.performance);
        feeds.setSource(FeedsSource.url);
        feeds.setName("Autotests feed");
        feeds.setUrl("https://yandex.st/market-export/1.0-17/partner/help/YML.xml");
        feeds.setFetchErrorsCount(0);
        feeds.setRefreshInterval((long) 86400);
        feeds.setUpdateStatus(FeedsUpdateStatus.New);
        long feedId = jooqDbSteps.feedsSteps().createFeed(feeds, User.get(login).getClientID());

        AdgroupsPerformanceRecord adgroupsPerformance = new AdgroupsPerformanceRecord();
        adgroupsPerformance.setPid(pid);
        adgroupsPerformance.setFeedId(feedId);
        adgroupsPerformance.setStatusblgenerated(AdgroupsPerformanceStatusblgenerated.No);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                .updateAdgroupsPerformance(adgroupsPerformance);

        long creativeId = jooqDbSteps.perfCreativesSteps().saveDefaultPerfCreative(User.get(login).getClientID());
        jooqDbSteps.bannersPerformanceSteps().saveNewBannersPerformance(cid, pid, bid, creativeId);
        jooqDbSteps.bidsPerformanceSteps().saveDefaultBidsPerformance(pid, BidsPerformanceNowOptimizingBy.CPA);

        return bid;
    }

    public Long addAndAcceptAnotherPerformanceGroupWithBanner(String login, int cid, int shard) {
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        api.userSteps.campaignFakeSteps().setType(cid, CampaignsType.TEXT);

        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);

        PhrasesRecord phrasesRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().getPhrases(pid);
        phrasesRecord.setAdgroupType(PhrasesAdgroupType.performance);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().updatePhrases(phrasesRecord);
        BannersRecord bannersRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(bid);
        bannersRecord.setBannerType(BannersBannerType.performance);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().updateBanners(bannersRecord);

        api.userSteps.campaignFakeSteps().setType(cid, CampaignsType.PERFORMANCE);

        long feedId = jooqDbSteps.feedsSteps().createDefaultFeed(User.get(login).getClientID());

        AdgroupsPerformanceRecord adgroupsPerformance = new AdgroupsPerformanceRecord();
        adgroupsPerformance.setPid(pid);
        adgroupsPerformance.setFeedId(feedId);
        adgroupsPerformance.setStatusblgenerated(AdgroupsPerformanceStatusblgenerated.No);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                .updateAdgroupsPerformance(adgroupsPerformance);

        long creativeId = jooqDbSteps.perfCreativesSteps().saveDefaultPerfCreative(User.get(login).getClientID());
        jooqDbSteps.bannersPerformanceSteps().saveNewBannersPerformance(cid, pid, bid, creativeId);
        jooqDbSteps.bidsPerformanceSteps().saveDefaultBidsPerformance(pid, BidsPerformanceNowOptimizingBy.CPA);
        return bid;
    }

    public Long addAndAcceptAnotherPerformanceGroupWithBanner(String login, Long cid, int shard) {
        return addAndAcceptAnotherPerformanceGroupWithBanner(login, cid.intValue(), shard);
    }


    public Long addAndAcceptAnotherPerformanceBanner(String login, int cid, Long pid, int shard) {
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        api.userSteps.campaignFakeSteps().setType(cid, CampaignsType.TEXT);

        PhrasesRecord phrasesRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().getPhrases(pid);
        phrasesRecord.setAdgroupType(PhrasesAdgroupType.base);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().updatePhrases(phrasesRecord);

        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        phrasesRecord.setAdgroupType(PhrasesAdgroupType.performance);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().updatePhrases(phrasesRecord);
        BannersRecord bannersRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(bid);
        bannersRecord.setBannerType(BannersBannerType.performance);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().updateBanners(bannersRecord);

        api.userSteps.campaignFakeSteps().setType(cid, CampaignsType.PERFORMANCE);

        long creativeId = jooqDbSteps.perfCreativesSteps().saveDefaultPerfCreative(User.get(login).getClientID());
        jooqDbSteps.bannersPerformanceSteps().saveNewBannersPerformance(cid, pid, bid, creativeId);

        return bid;
    }

    public Long addAndAcceptAnotherPerformanceBanner(String login, Long cid, Long pid, int shard) {
        return addAndAcceptAnotherPerformanceBanner(login, cid.intValue(), pid, shard);
    }

    @Step("Получение ожидаемых в запросе транспорта данных нацеливания (dyn_cond_id = {0})")
    public Dynamic buildExpectedDynamicObjFromDb(long dynId, int shard, UpdateInfo updateInfo) {
        BidsDynamicRecord bidsDynamic =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsDynamicSteps().getBidsDynamic(dynId);

        Dynamic dynamic = new Dynamic();
        dynamic.setUpdateInfo(updateInfo.value());
        dynamic.setEid("" + bidsDynamic.getDynCondId());
        dynamic.setId("" + bidsDynamic.getDynCondId());

        return dynamic;
    }

    //Описание "почему так - https://st.yandex-team.ru/TESTIRT-6185"
    public String getRetConditionsBSStyle(Long conditionId) {
        final RetargetingCraftedSteps retCraftedSteps = directWebApiSteps.retargetingCraftedSteps();

        RetargetingConditionWeb retargetingListGetItem = retCraftedSteps.getConditions(
                singletonList(conditionId), emptyList(), null, null, api.login()).get(0);

        final Predicate<AbstractGoalWeb> isGryptaGoalId =
                a -> a.getId() >= TransportUtils.CRYPTA_GOALS_ID_LOWER_BOUND &&
                        a.getId() < TransportUtils.CRYPTA_GOALS_ID_UPPER_BOUND;

        final Map<Long, CryptaGoalsRecord> cryptaGoalsMap;

        boolean cryptaGoalPresents = retargetingListGetItem.getConditions().stream()
                .map(Condition::getGoals)
                .flatMap(Collection::stream)
                .anyMatch(isGryptaGoalId);

        if (cryptaGoalPresents) {
            cryptaGoalsMap = api.userSteps.getDirectJooqDbSteps().cryptaGoalsSteps().getCryptaGoalsRecords().stream()
                    .collect(toMap(CryptaGoalsRecord::getGoalId, identity()));
        } else {
            cryptaGoalsMap = new HashMap<>();
        }

        List<String> retConditionsBSStyle = new ArrayList<>();

        String metrikaConditionBSStyle = retargetingListGetItem.getConditions().stream()
                .filter(r -> r.getGoals().stream().noneMatch(isGryptaGoalId))
                .map(rule -> convertRuleToBs(rule, cryptaGoalsMap))
                .collect(joining("&"));
        retConditionsBSStyle.add(metrikaConditionBSStyle);

        if (retargetingListGetItem.getConditions().stream()
                .anyMatch(r -> r.getGoals().stream().allMatch(isGryptaGoalId))) {
            List<RetargetingConditionWeb> retConditions = retCraftedSteps.getConditions(
                    singletonList(conditionId), emptyList(), null, null, api.login());

            if (!retConditions.isEmpty()) {
                String cryptaConditionBSStyle = retConditions.get(0).getConditions().stream()
                        .filter(r -> r.getGoals().stream().allMatch(isGryptaGoalId))
                        .map(rule -> convertRuleToBs(rule, cryptaGoalsMap))
                        .collect(joining("&"));
                retConditionsBSStyle.add(cryptaConditionBSStyle);
            }
        }

        String retConditionBSStyle = retConditionsBSStyle.stream()
                .filter(cond -> cond != null && !cond.isEmpty())
                .collect(joining("&"));

        // В первом этапе охватного продукта в интерфейсе будет всего 4е дохода.
        // Но в транспорте к БК нужно отдавать именно Средний доход как два значения.
        // https://wiki.yandex-team.ru/users/aliho/projects/direct/crypta/#diapazondljaobshhixpol/vozrast/doxod
        retConditionBSStyle = retConditionBSStyle.replace("1:0@618", "1:0@618|2:0@618");

        // В рамках охватного продукта пользователь на группе объявления может задать ограничение по ГЕО
        // и при этом не задать ограничение по крипте+-метрике (те ничего из Аудиторных условий).
        // В этом случае в транспорт необходимо будет отправить: спец ID на спец кейворде 1542:0@1
        if (retConditionBSStyle.isEmpty()) {
            retConditionBSStyle = "1542:0@1";
        }

        return retConditionBSStyle;
    }

    private String convertRuleToBs(Condition rule, Map<Long, CryptaGoalsRecord> cryptaGoalsMap) {
        List<List<AbstractGoalWeb>> goalGroups = getGoalGroups(rule);

        if (rule.getType().equals(Condition.TypeEnum.ALL)) {
            return goalGroups.stream()
                    .map(goalGroup -> convertGoalGroupToBs(goalGroup, rule, cryptaGoalsMap, false))
                    .collect(joining("&"));
        } else if (rule.getType().equals(Condition.TypeEnum.NOT)) {
            return goalGroups.stream()
                    .map(goalGroup -> "~" + convertGoalGroupToBs(goalGroup, rule, cryptaGoalsMap, false))
                    .collect(joining("&"));
        } else if (rule.getType().equals(Condition.TypeEnum.OR)) {
            return goalGroups.stream()
                    .map(goalGroup -> convertGoalGroupToBs(goalGroup, rule, cryptaGoalsMap, true))
                    .collect(joining("|", "(", ")"));
        } else {
            throw new RuntimeException("Невалидный тип правила");
        }
    }

    private List<List<AbstractGoalWeb>> getGoalGroups(Condition rule) {
        Map<Long, List<AbstractGoalWeb>> goalUnionGroups = rule.getGoals()
                .stream()
                .filter(goal -> goal.getUnionWithId() == null)
                .collect(toMap(AbstractGoalWeb::getId, goal -> new ArrayList<>(singletonList(goal)), (l, r) -> l));

        rule.getGoals().stream()
                .filter(goal -> goal.getUnionWithId() != null)
                .forEach(goal -> {
                    if (!goalUnionGroups.containsKey(goal.getUnionWithId())) {
                        throw new RuntimeException("Цель с id=union_with_id отсутствует в правиле");
                    }
                    goalUnionGroups.get(goal.getUnionWithId()).add(goal);
                });

        return rule.getGoals().stream()
                .filter(goal -> goalUnionGroups.containsKey(goal.getId()))
                .map(goal -> goalUnionGroups.get(goal.getId()))
                .collect(toList());
    }

    private String convertGoalGroupToBs(List<AbstractGoalWeb> goalGroup,
                                        Condition rule,
                                        Map<Long, CryptaGoalsRecord> cryptaGoalsMap,
                                        boolean skipParentheses) {
        List<String> convertedGoals = goalGroup.stream()
                .map(goal -> {
                    if (goal instanceof MetrikaGoalWeb) {
                        return Stream.of(convertMetrikaGoalToBsStyle(goal));
                    } else if (goal instanceof CryptaGoalWeb) {
                        final CryptaGoalsRecord cryptaGoal = cryptaGoalsMap.get(goal.getId());

                        final String longTermExpr =
                                (rule.getInterestType() == null ||
                                        rule.getInterestType() == Condition.InterestTypeEnum.ALL ||
                                        rule.getInterestType() == Condition.InterestTypeEnum.LONG_TERM) &&
                                        (cryptaGoal.getInterestType() == null ||
                                                cryptaGoal.getInterestType() == CryptaGoalsInterestType.all ||
                                                cryptaGoal.getInterestType() == CryptaGoalsInterestType.long_term) ?
                                        cryptaGoal.getBbKeywordValue() + ":" + 0 + "@" + cryptaGoal.getBbKeyword() : null;

                        final String shortTermExpr =
                                (rule.getInterestType() == null ||
                                        rule.getInterestType() == Condition.InterestTypeEnum.ALL ||
                                        rule.getInterestType() == Condition.InterestTypeEnum.SHORT_TERM) &&
                                        (cryptaGoal.getInterestType() == null ||
                                                cryptaGoal.getInterestType() == CryptaGoalsInterestType.all ||
                                                cryptaGoal.getInterestType() == CryptaGoalsInterestType.short_term) ?
                                        cryptaGoal.getBbKeywordValueShort() + ":" + 0 + "@"
                                                + cryptaGoal.getBbKeywordShort() : null;

                        return cryptaGoal.getCryptaGoalType() == CryptaGoalsCryptaGoalType.interests ?
                                Stream.of(longTermExpr, shortTermExpr).filter(Objects::nonNull) :
                                Stream.of(cryptaGoal.getBbKeywordValue() + ":" + 0 + "@" + cryptaGoal.getBbKeyword());
                    }
                    return null;
                })
                .flatMap(identity())
                .collect(toList());
        String convertedGoalGroup = String.join("|", convertedGoals);

        if (convertedGoals.size() > 1 && !skipParentheses) {
            convertedGoalGroup = "(" + convertedGoalGroup + ")";
        }
        return convertedGoalGroup;
    }

    private final HashMap<AbstractGoalWeb.TypeEnum, String> BS_KEYWORD_BY_GOAL_TYPE =
            new HashMap<AbstractGoalWeb.TypeEnum, String>() {
        {
            put(AbstractGoalWeb.TypeEnum.CDP_SEGMENT, "@1018");
        }
    };

    private String convertMetrikaGoalToBsStyle(AbstractGoalWeb goal) {
        MetrikaGoalWeb g = (MetrikaGoalWeb) goal;
        AbstractGoalWeb.TypeEnum goalType = g.getType();
        Integer time = goalType == AbstractGoalWeb.TypeEnum.CDP_SEGMENT
                ? 0
                : g.getTime() == null
                    ? 90
                    : g.getTime();
        String keyword = BS_KEYWORD_BY_GOAL_TYPE.getOrDefault(goalType, "");
        return goal.getId() + ":" + time + keyword;
    }

    public List<String> getRetConditionsBSStyleElements(Long conditionId) {
        return Arrays.asList(getRetConditionsBSStyle(conditionId).split("[&|]"));
    }

    public void addAndAcceptPerformanceTGOGroupWithBanner(String login, PerformanceBannersRule bannersRule,
            int shard)
    {
        Long creativeId = TestEnvironment.newDbSteps().useShardForLogin(login).perfCreativesSteps()
                .saveDefaultPerfTGOCreative(Long.valueOf(User.get(login).getClientID()));
        Group newGroup = bannersRule.getGroup().withAdGroupID(bannersRule.getGroupId().toString());
        CreativeBanner creativeBanner = new CreativeBanner();
        creativeBanner.setCreativeId(creativeId);

        newGroup.getBanners().get(0)
                .withCreativeBanner(creativeBanner)
                .withAdGroupId(bannersRule.getGroupId())
                .withBid(bannersRule.getBannerId());
        bannersRule.saveGroup(GroupsParameters.forExistingCamp(login, bannersRule.getCampaignId(), newGroup));

        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().updateBanners(
                api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(bannersRule.getBannerId())
                        .setStatusmoderate(BannersStatusmoderate.Yes)
                        .setStatussitelinksmoderate(BannersStatussitelinksmoderate.Yes)
                        .setPhoneflag(BannersPhoneflag.Yes)
                        .setStatuspostmoderate(BannersStatuspostmoderate.Yes)
        );

        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().updatePhrases(
                api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                        .getPhrases(bannersRule.getGroupId())
                        .setStatusmoderate(PhrasesStatusmoderate.Yes)
                        .setStatuspostmoderate(PhrasesStatuspostmoderate.Yes)
        );

        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersPerformanceSteps()
                .setCreativeStatusModerate(bannersRule.getCampaignId(),
                        bannersRule.getGroupId(), bannersRule.getBannerId(), BannersPerformanceStatusmoderate.Yes);

        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .perfCreativesSteps().setStatusModerate(creativeId, PerfCreativesStatusmoderate.Yes);

    }

    public void addAndAcceptAnotherPerformanceGroupWithBanner(String login, PerformanceBannersRule bannersRule,
            int shard)
    {
        Long creativeId = TestEnvironment.newDbSteps().useShardForLogin(login).perfCreativesSteps()
                .saveDefaultPerfCreative(Long.valueOf(User.get(login).getClientID()));
        Group newGroup = bannersRule.getGroup();
        CreativeBanner creativeBanner = new CreativeBanner();
        creativeBanner.setCreativeId(creativeId);

        newGroup.getBanners().get(0).withCreativeBanner(creativeBanner);
        bannersRule.saveGroup(GroupsParameters.forExistingCamp(login, bannersRule.getCampaignId(), newGroup));

        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().updateBanners(
                api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(bannersRule.getBannerId())
                        .setStatusmoderate(BannersStatusmoderate.Yes)
                        .setStatussitelinksmoderate(BannersStatussitelinksmoderate.Yes)
                        .setPhoneflag(BannersPhoneflag.Yes)
                        .setStatuspostmoderate(BannersStatuspostmoderate.Yes)
        );

        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().updatePhrases(
                api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                        .getPhrases(bannersRule.getGroupId())
                        .setStatusmoderate(PhrasesStatusmoderate.Yes)
                        .setStatuspostmoderate(PhrasesStatuspostmoderate.Yes)
        );

        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersPerformanceSteps()
                .setCreativeStatusModerate(bannersRule.getCampaignId(),
                        bannersRule.getGroupId(), bannersRule.getBannerId(), BannersPerformanceStatusmoderate.Yes);

        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .perfCreativesSteps().setStatusModerate(api.userSteps.getDirectJooqDbSteps().useShard(shard)
                        .bannersPerformanceSteps().getBannersPerformance(
                        bannersRule.getCampaignId(), bannersRule.getGroupId(), bannersRule.getBannerId())
                        .getCreativeId(),
                PerfCreativesStatusmoderate.Yes);

    }


    public Long addAndAcceptAnotherPerformanceBanner(String login, PerformanceBannersRule bannersRule, int shard) {
        Long creativeId = TestEnvironment.newDbSteps().useShardForLogin(login).perfCreativesSteps()
                .saveDefaultPerfCreative(Long.valueOf(User.get(login).getClientID()));
        Group group = bannersRule.getCurrentGroup();

        group.getBanners().add(
                BannersRuleFactory.getBannersRuleBuilderByCampType(CampaignTypeEnum.DMO)
                        .getBanner().withCreativeBanner(
                        new CreativeBanner()
                                .withCreativeId(creativeId)
                                .withHeight("100")
                                .withWidth("100")
                                .withName("testName")
                                .withPreviewUrl("ya.ru")
                )
                        .withTitle("{Перфоманс заголовок}")
                        .withBody("{Перфоманс текст}")
                        .withAdGroupId(bannersRule.getGroupId())


        );

        bannersRule.saveGroup(GroupsParameters.forExistingCamp(login, bannersRule.getCampaignId(),
                group.withAdGroupID(String.valueOf(bannersRule.getGroupId())).withHrefParams("")
                        .withMinusWords(new ArrayList<>()).withBannersQuantity((long) 2)));

        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().updateBanners(
                api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(bannersRule.getBannerId())
                        .setStatusmoderate(BannersStatusmoderate.Yes)
                        .setStatussitelinksmoderate(BannersStatussitelinksmoderate.Yes)
                        .setPhoneflag(BannersPhoneflag.Yes)
                        .setStatuspostmoderate(BannersStatuspostmoderate.Yes)
        );

        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().updatePhrases(
                api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                        .getPhrases(bannersRule.getGroupId())
                        .setStatusmoderate(PhrasesStatusmoderate.Yes)
                        .setStatuspostmoderate(PhrasesStatuspostmoderate.Yes)
        );

        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersPerformanceSteps()
                .setCreativeStatusModerate(bannersRule.getCampaignId(),
                        bannersRule.getGroupId(), bannersRule.getBannerId(), BannersPerformanceStatusmoderate.Yes);

        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .perfCreativesSteps().setStatusModerate(creativeId, PerfCreativesStatusmoderate.Yes);

        return bannersRule.getBannerId();

    }

    public void makePerformanceCampaignReadyForSendingToBS(PerformanceBannersRule bannersRule, int shard) {
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().updateCampaigns(
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                        .getCampaignById(bannersRule.getCampaignId())
                        .setStatusmoderate(CampaignsStatusmoderate.Yes)
                        .setSum(BigDecimal.TEN)
        );

        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().updateCampOptions(
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                        .getCampOptionsById(bannersRule.getCampaignId())
                        .setStatuspostmoderate(CampOptionsStatuspostmoderate.Accepted)
        );

        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().updateBanners(
                api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(bannersRule.getBannerId())
                        .setStatusmoderate(BannersStatusmoderate.Yes)
                        .setStatussitelinksmoderate(BannersStatussitelinksmoderate.Yes)
                        .setPhoneflag(BannersPhoneflag.Yes)
                        .setStatuspostmoderate(BannersStatuspostmoderate.Yes)
        );

        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().updatePhrases(
                api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                        .getPhrases(bannersRule.getGroupId())
                        .setStatusmoderate(PhrasesStatusmoderate.Yes)
                        .setStatuspostmoderate(PhrasesStatuspostmoderate.Yes)
        );

        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersPerformanceSteps()
                .setCreativeStatusModerate(bannersRule.getCampaignId(),
                        bannersRule.getGroupId(), bannersRule.getBannerId(), BannersPerformanceStatusmoderate.Yes);

        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .perfCreativesSteps().setStatusModerate(api.userSteps.getDirectJooqDbSteps().useShard(shard)
                        .bannersPerformanceSteps().getBannersPerformance(
                        bannersRule.getCampaignId(), bannersRule.getGroupId(), bannersRule.getBannerId())
                        .getCreativeId(),
                PerfCreativesStatusmoderate.Yes);
    }

    /**
     * Подготавливает кампанию и новый родительский performance-баннер для отправки в БК
     */
    public void makeCampWithPerformanceMainBannerReadyForSendingToBS(PerformanceBannersRule bannersRule, int shard) {
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().updateCampaigns(
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                        .getCampaignById(bannersRule.getCampaignId())
                        .setStatusmoderate(CampaignsStatusmoderate.Yes)
                        .setSum(BigDecimal.TEN)
        );

        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().updateCampOptions(
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                        .getCampOptionsById(bannersRule.getCampaignId())
                        .setStatuspostmoderate(CampOptionsStatuspostmoderate.Accepted)
        );

        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().updateBanners(
                api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(bannersRule.getBannerId())
                        .setStatusmoderate(BannersStatusmoderate.Yes)
                        .setStatussitelinksmoderate(BannersStatussitelinksmoderate.Yes)
                        .setPhoneflag(BannersPhoneflag.Yes)
                        .setStatuspostmoderate(BannersStatuspostmoderate.Yes)
        );

        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().updatePhrases(
                api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                        .getPhrases(bannersRule.getGroupId())
                        .setStatusmoderate(PhrasesStatusmoderate.Yes)
                        .setStatuspostmoderate(PhrasesStatuspostmoderate.Yes)
        );

        // Поменять тип баннера на performance_main
        Long bannerId = bannersRule.getBannerId();
        BannersRecord bannerRecord = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bannersSteps().getBanner(bannerId);
        bannerRecord.setBannerType(BannersBannerType.performance_main);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().updateBanners(bannerRecord);

        // Удалить записи из banners_performance и perf_creatives: новый баннер не содержит креатива
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersPerformanceSteps()
                .deleteBannersPerformanceRecord(bannersRule.getCreativeId());
        api.userSteps.getDirectJooqDbSteps().useShard(shard).perfCreativesSteps()
                .deletePerfCreatives(bannersRule.getCreativeId());
    }

    public String calculateBannerId(Long exportId) {
        return String.valueOf((exportId & 0x00FFFFFFFFFFFFFFL) + 0x0100000000000000L);
    }

    @Step("Добавление флага single_ad_to_bs отправки в родительском баннере картиночной версии (в banner_images.opts)")
    public void setImageOptsToSingleAdToBs(int shard, long bid) {
        Set<JooqBannerImagesOpts> opts = new HashSet<>();
        opts.add(JooqBannerImagesOpts.SINGLE_AD_TO_BS);
        api.userSteps.getDirectJooqDbSteps()
                .useShard(shard)
                .imagesSteps()
                .setImageOpts(bid, opts);
    }
}
